/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.jmx.impl.JmxKernelExtension;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.management.Cache;
import org.neo4j.management.ManagementBeansTest;

public class TestCacheBeans {
    private AbstractGraphDatabase graphDb;
    private Collection<Cache> caches;

    @Before
    public synchronized void startGraphDb() {
        this.graphDb = new EmbeddedGraphDatabase("target" + File.separator + "var" + File.separator + ManagementBeansTest.class.getSimpleName());
        this.caches = ((JmxKernelExtension)this.graphDb.getDependencyResolver().resolveDependency(JmxKernelExtension.class)).getManagementBeans(Cache.class);
    }

    @After
    public synchronized void stopGraphDb() {
        if (this.graphDb != null) {
            this.graphDb.shutdown();
        }
        this.graphDb = null;
    }

    @Test
    public void canAccessCacheBeans() throws Exception {
        Assert.assertNotNull((String)"no cache beans", this.caches);
        Assert.assertFalse((String)"no cache beans", (boolean)this.caches.isEmpty());
    }

    @Test
    public void canMeasureSizeOfCache() throws Exception {
        long[] before = this.get(CacheBean.NUMBER_OF_CACHED_ELEMENTS);
        this.graphDb.getReferenceNode();
        this.assertChanged("cache size not updated", before, this.get(CacheBean.NUMBER_OF_CACHED_ELEMENTS));
    }

    @Test
    public void canMeasureAmountsOfHitsAndMisses() throws Exception {
        long[] hits = this.get(CacheBean.HIT_COUNT);
        long[] miss = this.get(CacheBean.MISS_COUNT);
        this.graphDb.getReferenceNode();
        this.graphDb.getReferenceNode();
        this.assertChanged("hit count not updated", hits, this.get(CacheBean.HIT_COUNT));
        this.assertChanged("miss count not updated", miss, this.get(CacheBean.MISS_COUNT));
    }

    private void assertChanged(String message, long[] before, long[] after) {
        if (Arrays.equals(before, after)) {
            Assert.fail((String)(message + ", before=" + Arrays.toString(before) + ", after=" + Arrays.toString(after)));
        }
    }

    private long[] get(CacheBean accessor) {
        long[] result = new long[this.caches.size()];
        Iterator<Cache> iter = this.caches.iterator();
        for (int i = 0; i < result.length; ++i) {
            result[i] = accessor.get(iter.next());
        }
        return result;
    }

    private static enum CacheBean {
        NUMBER_OF_CACHED_ELEMENTS{

            @Override
            long get(Cache bean) {
                return bean.getCacheSize();
            }
        }
        ,
        HIT_COUNT{

            @Override
            long get(Cache bean) {
                return bean.getHitCount();
            }
        }
        ,
        MISS_COUNT{

            @Override
            long get(Cache bean) {
                return bean.getMissCount();
            }
        };


        abstract long get(Cache var1);
    }
}

