/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management;

import java.io.File;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.jmx.impl.JmxKernelExtension;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.info.LockInfo;
import org.neo4j.kernel.info.LockingTransaction;
import org.neo4j.kernel.info.ResourceType;
import org.neo4j.kernel.info.WaitingThread;
import org.neo4j.management.LockManager;
import org.neo4j.management.ManagementBeansTest;

public class TestLockManagerBean {
    private LockManager lockManager;
    private static AbstractGraphDatabase graphDb;

    @Before
    public void setupLockManager() {
        this.lockManager = (LockManager)((JmxKernelExtension)graphDb.getDependencyResolver().resolveDependency(JmxKernelExtension.class)).getSingleManagementBean(LockManager.class);
    }

    @Test
    public void restingGraphHoldsNoLocks() {
        Assert.assertEquals((String)"unexpected lock count", (long)0L, (long)this.lockManager.getLocks().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void modifiedNodeImpliesLock() {
        List locks;
        Transaction tx = graphDb.beginTx();
        try {
            graphDb.getReferenceNode().setProperty("key", (Object)"value");
            locks = this.lockManager.getLocks();
            Assert.assertEquals((String)"unexpected lock count", (long)1L, (long)locks.size());
            LockInfo lock = (LockInfo)locks.get(0);
            Assert.assertNotNull((String)"null lock", (Object)lock);
            List transactions = lock.getLockingTransactions();
            Assert.assertEquals((String)"unexpected transaction count", (long)1L, (long)transactions.size());
            LockingTransaction txInfo = (LockingTransaction)transactions.iterator().next();
            Assert.assertNotNull((String)"null transaction", (Object)txInfo);
            Assert.assertEquals((String)"read count", (long)0L, (long)txInfo.getReadCount());
            Assert.assertEquals((String)"write count", (long)2L, (long)txInfo.getWriteCount());
            Assert.assertNotNull((String)"transaction", (Object)txInfo.getTransaction());
            Assert.assertEquals((String)"read count", (long)0L, (long)lock.getReadCount());
            Assert.assertEquals((String)"write count", (long)2L, (long)lock.getWriteCount());
            Assert.assertEquals((String)"waiting thread count", (long)0L, (long)lock.getWaitingThreadsCount());
        }
        finally {
            tx.finish();
        }
        locks = this.lockManager.getLocks();
        Assert.assertEquals((String)"unexpected lock count", (long)0L, (long)locks.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void explicitLocksAffectTheLockCount() {
        Transaction tx = graphDb.beginTx();
        try {
            Node root = graphDb.getReferenceNode();
            Lock first = tx.acquireReadLock((PropertyContainer)root);
            LockInfo lock = this.getSingleLock();
            Assert.assertEquals((String)"read count", (long)1L, (long)lock.getReadCount());
            Assert.assertEquals((String)"write count", (long)0L, (long)lock.getWriteCount());
            tx.acquireReadLock((PropertyContainer)root);
            lock = this.getSingleLock();
            Assert.assertEquals((String)"read count", (long)2L, (long)lock.getReadCount());
            Assert.assertEquals((String)"write count", (long)0L, (long)lock.getWriteCount());
            tx.acquireWriteLock((PropertyContainer)root);
            lock = this.getSingleLock();
            Assert.assertEquals((String)"read count", (long)2L, (long)lock.getReadCount());
            Assert.assertEquals((String)"write count", (long)1L, (long)lock.getWriteCount());
            first.release();
            lock = this.getSingleLock();
            Assert.assertEquals((String)"read count", (long)1L, (long)lock.getReadCount());
            Assert.assertEquals((String)"write count", (long)1L, (long)lock.getWriteCount());
        }
        finally {
            tx.finish();
        }
        List locks = this.lockManager.getLocks();
        Assert.assertEquals((String)"unexpected lock count", (long)0L, (long)locks.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void canGetToContendedLocksOnly() throws Exception {
        final Node root = graphDb.getReferenceNode();
        Transaction tx = graphDb.beginTx();
        try {
            graphDb.createNode();
            Lock lock = tx.acquireReadLock((PropertyContainer)root);
            List locks = this.lockManager.getLocks();
            Assert.assertEquals((String)"unexpected lock count", (long)2L, (long)locks.size());
            block9: for (LockInfo l : locks) {
                switch (l.getResourceType()) {
                    case NODE: {
                        if ("0".equals(l.getResourceId())) {
                            Assert.assertEquals((String)"read count", (long)1L, (long)l.getReadCount());
                            Assert.assertEquals((String)"write count", (long)0L, (long)l.getWriteCount());
                            continue block9;
                        }
                        Assert.assertEquals((String)"read count", (long)0L, (long)l.getReadCount());
                        Assert.assertEquals((String)"write count", (long)1L, (long)l.getWriteCount());
                        continue block9;
                    }
                }
                Assert.fail((String)("Unexpected locked resource type: " + l.getResourceType()));
            }
            final CountDownLatch latch = new CountDownLatch(1);
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Transaction tx = graphDb.beginTx();
                    try {
                        root.setProperty("block", (Object)"here");
                    }
                    finally {
                        tx.finish();
                    }
                    latch.countDown();
                }
            };
            t.start();
            this.awaitWaitingStateIn(t);
            locks = this.lockManager.getLocks();
            Assert.assertEquals((String)"unexpected lock count", (long)2L, (long)locks.size());
            block10: for (LockInfo l : locks) {
                switch (l.getResourceType()) {
                    case NODE: {
                        if ("0".equals(l.getResourceId())) {
                            Assert.assertEquals((String)"read count", (long)1L, (long)l.getReadCount());
                            Assert.assertEquals((String)"write count", (long)0L, (long)l.getWriteCount());
                            List waiters = l.getWaitingThreads();
                            Assert.assertEquals((String)"unxpected number of waiting threads", (long)1L, (long)waiters.size());
                            WaitingThread waiter = (WaitingThread)waiters.get(0);
                            Assert.assertNotNull((Object)waiter);
                            continue block10;
                        }
                        Assert.assertEquals((String)"read count", (long)0L, (long)l.getReadCount());
                        Assert.assertEquals((String)"write count", (long)1L, (long)l.getWriteCount());
                        continue block10;
                    }
                }
                Assert.fail((String)("Unexpected locked resource type: " + l.getResourceType()));
            }
            locks = this.lockManager.getContendedLocks(0L);
            Assert.assertEquals((String)"unexpected lock count", (long)1L, (long)locks.size());
            LockInfo l = (LockInfo)locks.get(0);
            Assert.assertEquals((String)"resource type", (Object)ResourceType.NODE, (Object)l.getResourceType());
            Assert.assertEquals((String)"resource id", (Object)"0", (Object)l.getResourceId());
            Assert.assertEquals((String)"read count", (long)1L, (long)l.getReadCount());
            Assert.assertEquals((String)"write count", (long)0L, (long)l.getWriteCount());
            List waiters = l.getWaitingThreads();
            Assert.assertEquals((String)"unxpected number of waiting threads", (long)1L, (long)waiters.size());
            WaitingThread waiter = (WaitingThread)waiters.get(0);
            Assert.assertNotNull((Object)waiter);
            lock.release();
            latch.await();
        }
        finally {
            tx.finish();
        }
    }

    private void awaitWaitingStateIn(Thread t) {
        while (t.getState() != Thread.State.WAITING) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
    }

    private LockInfo getSingleLock() {
        List locks = this.lockManager.getLocks();
        Assert.assertEquals((String)"unexpected lock count", (long)1L, (long)locks.size());
        LockInfo lock = (LockInfo)locks.get(0);
        Assert.assertNotNull((String)"null lock", (Object)lock);
        return lock;
    }

    @BeforeClass
    public static synchronized void startGraphDb() {
        graphDb = new EmbeddedGraphDatabase("target" + File.separator + "var" + File.separator + ManagementBeansTest.class.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static synchronized void stopGraphDb() {
        try {
            if (graphDb != null) {
                graphDb.shutdown();
            }
        }
        finally {
            graphDb = null;
        }
    }
}

