/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.jmx.impl.JmxKernelExtension;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.management.XaManager;
import org.neo4j.management.XaResourceInfo;
import org.neo4j.management.impl.XaManagerBean;
import org.neo4j.test.TargetDirectory;

public class TestXaManagerBeans {
    private AbstractGraphDatabase graphDb;
    private XaManager xaManager;
    private TargetDirectory dir = TargetDirectory.forTest(this.getClass());

    @Before
    public synchronized void startGraphDb() {
        this.graphDb = new EmbeddedGraphDatabase(this.dir.directory("test").getAbsolutePath());
        this.xaManager = (XaManager)((JmxKernelExtension)this.graphDb.getDependencyResolver().resolveDependency(JmxKernelExtension.class)).getSingleManagementBean(XaManager.class);
    }

    @After
    public synchronized void stopGraphDb() {
        if (this.graphDb != null) {
            this.graphDb.shutdown();
        }
        this.graphDb = null;
    }

    @Test
    public void canAccessXaManagerBean() throws Exception {
        Assert.assertNotNull((String)"no XA manager bean", (Object)this.xaManager);
        Assert.assertTrue((String)"no XA resources", (this.xaManager.getXaResources().length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void hasAllXaManagerBeans() {
        for (XaDataSource xaDataSource : this.graphDb.getXaDataSourceManager().getAllRegisteredDataSources()) {
            XaResourceInfo info = this.getByName(xaDataSource.getName());
            Assert.assertEquals((String)("wrong branchid for XA data source " + xaDataSource.getName()), (Object)XaManagerBean.toHexString((byte[])xaDataSource.getBranchId()), (Object)info.getBranchId());
            Assert.assertEquals((String)("wrong log version for XA data source " + xaDataSource.getName()), (long)xaDataSource.getCurrentLogVersion(), (long)info.getLogVersion());
            Assert.assertEquals((String)("wrong last tx ID for XA data source " + xaDataSource.getName()), (long)xaDataSource.getLastCommittedTxId(), (long)info.getLastTxId());
        }
    }

    private XaResourceInfo getByName(String name) {
        for (XaResourceInfo xaResourceInfo : this.xaManager.getXaResources()) {
            if (!name.equals(xaResourceInfo.getName())) continue;
            return xaResourceInfo;
        }
        Assert.fail((String)("no such XA resource: " + name));
        return null;
    }
}

