/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import javax.management.ObjectName;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.jmx.Kernel;
import org.neo4j.jmx.Primitives;
import org.neo4j.jmx.impl.ManagementSupport;
import org.neo4j.management.BranchedStore;
import org.neo4j.management.Cache;
import org.neo4j.management.HighAvailability;
import org.neo4j.management.LockManager;
import org.neo4j.management.MemoryMapping;
import org.neo4j.management.StoreFile;
import org.neo4j.management.TransactionManager;
import org.neo4j.management.XaManager;
import org.neo4j.management.impl.AdvancedManagementSupport;

public class CodeDuplicationValidationTest {
    @Test
    public void kernelBeanTypeNameMatchesExpected() throws Exception {
        Assert.assertEquals((Object)Kernel.class.getName(), (Object)"org.neo4j.jmx.Kernel");
        Assert.assertEquals((Object)"Kernel", (Object)"Kernel");
    }

    @Test
    public void mbeanQueryAttributeNameMatchesMethodName() throws Exception {
        Assert.assertEquals(ObjectName.class, Kernel.class.getMethod("getMBeanQuery", new Class[0]).getReturnType());
    }

    @Test
    public void interfacesGetsTheSameBeanNames() throws Exception {
        this.assertEqualBeanName(Kernel.class);
        this.assertEqualBeanName(Primitives.class);
        this.assertEqualBeanName(Cache.class);
        this.assertEqualBeanName(HighAvailability.class);
        this.assertEqualBeanName(BranchedStore.class);
        this.assertEqualBeanName(LockManager.class);
        this.assertEqualBeanName(MemoryMapping.class);
        this.assertEqualBeanName(StoreFile.class);
        this.assertEqualBeanName(TransactionManager.class);
        this.assertEqualBeanName(XaManager.class);
    }

    private void assertEqualBeanName(Class<?> beanClass) {
        Assert.assertEquals((Object)new DefaultManagementSupport().getBeanName(beanClass), (Object)new CustomManagementSupport().getBeanName(beanClass));
    }

    @Test
    public void generatesEqualObjectNames() throws Exception {
        Assert.assertEquals((Object)new DefaultManagementSupport().createMBeanQuery("test-instance"), (Object)new CustomManagementSupport().createMBeanQuery("test-instance"));
        Assert.assertEquals((Object)new DefaultManagementSupport().createObjectName("test-instace", Kernel.class, new String[0]), (Object)new CustomManagementSupport().createObjectName("test-instace", Kernel.class, new String[0]));
    }

    private class CustomManagementSupport
    extends AdvancedManagementSupport {
        private CustomManagementSupport() {
        }
    }

    private class DefaultManagementSupport
    extends ManagementSupport {
        private DefaultManagementSupport() {
        }

        protected ObjectName createObjectName(String instanceId, String beanName, boolean query, String ... extraNaming) {
            return super.createObjectName(instanceId, beanName, query, extraNaming);
        }

        protected String getBeanName(Class<?> beanInterface) {
            return super.getBeanName(beanInterface);
        }
    }
}

