/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.neo4j.jmx.Kernel;
import org.neo4j.jmx.Primitives;
import org.neo4j.jmx.StoreFile;
import org.neo4j.management.BranchedStore;
import org.neo4j.management.Cache;
import org.neo4j.management.HighAvailability;
import org.neo4j.management.IndexSamplingManager;
import org.neo4j.management.LockManager;
import org.neo4j.management.MemoryMapping;
import org.neo4j.management.PageCache;
import org.neo4j.management.TransactionManager;
import org.neo4j.management.impl.KernelProxy;

public final class Neo4jManager
extends KernelProxy
implements Kernel {
    private final ObjectName config = this.createObjectName("Configuration");
    private final Kernel proxy = this.getBean(Kernel.class);

    public static Neo4jManager get() {
        return Neo4jManager.get(ManagementFactory.getPlatformMBeanServer());
    }

    public static Neo4jManager get(String kernelIdentifier) {
        return Neo4jManager.get((MBeanServerConnection)ManagementFactory.getPlatformMBeanServer(), kernelIdentifier);
    }

    public static Neo4jManager get(JMXServiceURL url) {
        return Neo4jManager.get(Neo4jManager.connect(url, null, null));
    }

    public static Neo4jManager get(JMXServiceURL url, String kernelIdentifier) {
        return Neo4jManager.get(Neo4jManager.connect(url, null, null), kernelIdentifier);
    }

    public static Neo4jManager get(JMXServiceURL url, String username, String password) {
        return Neo4jManager.get(Neo4jManager.connect(url, username, password));
    }

    public static Neo4jManager get(JMXServiceURL url, String username, String password, String kernelIdentifier) {
        return Neo4jManager.get(Neo4jManager.connect(url, username, password), kernelIdentifier);
    }

    private static MBeanServerConnection connect(JMXServiceURL url, String username, String password) {
        HashMap<String, Object> environment = new HashMap<String, Object>();
        if (username != null && password != null) {
            environment.put("jmx.remote.credentials", new String[]{username, password});
        } else if (username != password) {
            throw new IllegalArgumentException("User name and password must either both be specified, or both be null.");
        }
        try {
            try {
                return JMXConnectorFactory.connect(url, environment).getMBeanServerConnection();
            }
            catch (SecurityException e) {
                environment.put("jmx.remote.rmi.client.socket.factory", new SslRMIClientSocketFactory());
                return JMXConnectorFactory.connect(url, environment).getMBeanServerConnection();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection failed.", e);
        }
    }

    public static Neo4jManager get(MBeanServerConnection server) {
        server.getClass();
        try {
            return Neo4jManager.get(server, server.queryNames(Neo4jManager.createObjectName("*", Kernel.class), null));
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection failed.", e);
        }
    }

    public static Neo4jManager get(MBeanServerConnection server, String kernelIdentifier) {
        server.getClass();
        kernelIdentifier.getClass();
        try {
            return Neo4jManager.get(server, server.queryNames(Neo4jManager.createObjectName(kernelIdentifier, Kernel.class), null));
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection failed.", e);
        }
    }

    public static Neo4jManager[] getAll(MBeanServerConnection server) {
        try {
            Set<ObjectName> kernels = server.queryNames(Neo4jManager.createObjectName("*", Kernel.class), null);
            Neo4jManager[] managers = new Neo4jManager[kernels.size()];
            Iterator<ObjectName> it = kernels.iterator();
            for (int i = 0; i < managers.length; ++i) {
                managers[i] = new Neo4jManager(server, it.next());
            }
            return managers;
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection failed.", e);
        }
    }

    private static Neo4jManager get(MBeanServerConnection server, Collection<ObjectName> kernels) {
        if (kernels.size() == 0) {
            throw new NoSuchElementException("No matching Neo4j Graph Database running on server");
        }
        if (kernels.size() == 1) {
            return new Neo4jManager(server, kernels.iterator().next());
        }
        throw new NoSuchElementException("Too many matching Neo4j Graph Databases running on server");
    }

    public Neo4jManager(Kernel kernel) {
        this(Neo4jManager.getServer(kernel), Neo4jManager.getName(kernel));
    }

    private static MBeanServerConnection getServer(Kernel kernel) {
        if (kernel instanceof Proxy) {
            InvocationHandler handler = Proxy.getInvocationHandler(kernel);
            if (handler instanceof MBeanServerInvocationHandler) {
                return ((MBeanServerInvocationHandler)handler).getMBeanServerConnection();
            }
        } else if (kernel instanceof Neo4jManager) {
            return ((Neo4jManager)kernel).server;
        }
        throw new UnsupportedOperationException("Cannot get server for kernel: " + kernel);
    }

    private static ObjectName getName(Kernel kernel) {
        if (kernel instanceof Proxy) {
            InvocationHandler handler = Proxy.getInvocationHandler(kernel);
            if (handler instanceof MBeanServerInvocationHandler) {
                return ((MBeanServerInvocationHandler)handler).getObjectName();
            }
        } else if (kernel instanceof Neo4jManager) {
            return ((Neo4jManager)kernel).kernel;
        }
        throw new UnsupportedOperationException("Cannot get name for kernel: " + kernel);
    }

    private Neo4jManager(MBeanServerConnection server, ObjectName kernel) {
        super(server, kernel);
    }

    public Collection<Cache> getCacheBeans() {
        return this.getBeans(Cache.class);
    }

    public LockManager getLockManagerBean() {
        return this.getBean(LockManager.class);
    }

    public IndexSamplingManager getIndexSamplingManagerBean() {
        return this.getBean(IndexSamplingManager.class);
    }

    public MemoryMapping getMemoryMappingBean() {
        return this.getBean(MemoryMapping.class);
    }

    public Primitives getPrimitivesBean() {
        return this.getBean(Primitives.class);
    }

    public StoreFile getStoreFileBean() {
        return this.getBean(StoreFile.class);
    }

    public TransactionManager getTransactionManagerBean() {
        return this.getBean(TransactionManager.class);
    }

    public PageCache getPageCacheBean() {
        return this.getBean(PageCache.class);
    }

    public HighAvailability getHighAvailabilityBean() {
        return this.getBean(HighAvailability.class);
    }

    public BranchedStore getBranchedStoreBean() {
        return this.getBean(BranchedStore.class);
    }

    public Object getConfigurationParameter(String key) {
        try {
            return this.server.getAttribute(this.config, key);
        }
        catch (AttributeNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not access the configuration bean", e);
        }
    }

    public Map<String, Object> getConfiguration() {
        AttributeList attributes;
        int i;
        String[] keys;
        try {
            MBeanAttributeInfo[] keyInfo = this.server.getMBeanInfo(this.config).getAttributes();
            keys = new String[keyInfo.length];
            for (i = 0; i < keys.length; ++i) {
                keys[i] = keyInfo[i].getName();
            }
            attributes = this.server.getAttributes(this.config, keys);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not access the configuration bean", e);
        }
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        for (i = 0; i < keys.length; ++i) {
            configuration.put(keys[i], attributes.get(i));
        }
        return configuration;
    }

    @Override
    public List<Object> allBeans() {
        List<Object> beans = super.allBeans();
        Kernel kernel = null;
        for (Object bean : beans) {
            if (!(bean instanceof Kernel)) continue;
            kernel = (Kernel)bean;
        }
        if (kernel != null) {
            beans.remove(kernel);
        }
        return beans;
    }

    public Date getKernelStartTime() {
        return this.proxy.getKernelStartTime();
    }

    public String getKernelVersion() {
        return this.proxy.getKernelVersion();
    }

    public ObjectName getMBeanQuery() {
        return this.proxy.getMBeanQuery();
    }

    public Date getStoreCreationDate() {
        return this.proxy.getStoreCreationDate();
    }

    public String getStoreDirectory() {
        return this.proxy.getStoreDirectory();
    }

    public String getStoreId() {
        return this.proxy.getStoreId();
    }

    public long getStoreLogVersion() {
        return this.proxy.getStoreLogVersion();
    }

    public boolean isReadOnly() {
        return this.proxy.isReadOnly();
    }
}

