/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management;

import org.neo4j.jmx.Description;
import org.neo4j.jmx.ManagementInterface;

@ManagementInterface(name="Page cache")
@Description(value="Information about the Neo4j page cache")
public interface PageCache {
    public static final String NAME = "Page cache";

    @Description(value="Number of page faults")
    public long getFaults();

    @Description(value="Number of page evictions")
    public long getEvictions();

    @Description(value="Number of page pins")
    public long getPins();

    @Description(value="Number of page unpins")
    public long getUnpins();

    @Description(value="Number of page flushes")
    public long getFlushes();

    @Description(value="Number of bytes read from durable storage")
    public long getBytesRead();

    @Description(value="Number of bytes written to durable storage")
    public long getBytesWritten();

    @Description(value="Number of files that have been mapped into the page cache")
    public long getFileMappings();

    @Description(value="Number of files that have been unmapped from the page cache")
    public long getFileUnmappings();

    @Description(value="Number of exceptions caught during page eviction")
    public long getEvictionExceptions();
}

