/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import javax.management.NotCompliantMBeanException;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.management.IndexSamplingManager;

public final class IndexSamplingManagerBean
extends ManagementBeanProvider {
    public IndexSamplingManagerBean() {
        super(IndexSamplingManager.class);
    }

    protected Neo4jMBean createMBean(ManagementData management) throws NotCompliantMBeanException {
        return new IndexSamplingManagerImpl(management);
    }

    protected Neo4jMBean createMXBean(ManagementData management) throws NotCompliantMBeanException {
        return new IndexSamplingManagerImpl(management, true);
    }

    private static StoreAccess access(ManagementData management) {
        StoreAccess access = new StoreAccess();
        ((DataSourceManager)management.getKernelData().graphDatabase().getDependencyResolver().resolveDependency(DataSourceManager.class)).addListener((DataSourceManager.Listener)access);
        return access;
    }

    static class StoreAccess
    implements DataSourceManager.Listener {
        private volatile State state;

        StoreAccess() {
        }

        public void registered(NeoStoreDataSource dataSource) {
            this.state = new State(dataSource.getStoreLayer(), dataSource.getIndexService());
        }

        public void unregistered(NeoStoreDataSource dataSource) {
            this.state = null;
        }

        public void triggerIndexSampling(String labelKey, String propertyKey, boolean forceSample) {
            int labelKeyId = -1;
            int propertyKeyId = -1;
            State state = this.state;
            if (state != null) {
                labelKeyId = state.storeLayer.labelGetForName(labelKey);
                propertyKeyId = state.storeLayer.propertyKeyGetForName(propertyKey);
            }
            if (labelKeyId == -1 || propertyKeyId == -1) {
                throw new IllegalArgumentException("No property or label key was found associated with " + propertyKey + " and " + labelKey);
            }
            state.indexingService.triggerIndexSampling(new IndexDescriptor(labelKeyId, propertyKeyId), this.getIndexSamplingMode(forceSample));
        }

        private IndexSamplingMode getIndexSamplingMode(boolean forceSample) {
            if (forceSample) {
                return IndexSamplingMode.TRIGGER_REBUILD_ALL;
            }
            return IndexSamplingMode.TRIGGER_REBUILD_UPDATED;
        }

        private static class State {
            final StoreReadLayer storeLayer;
            final IndexingService indexingService;

            State(StoreReadLayer storeLayer, IndexingService indexingService) {
                this.storeLayer = storeLayer;
                this.indexingService = indexingService;
            }
        }
    }

    private static class IndexSamplingManagerImpl
    extends Neo4jMBean
    implements IndexSamplingManager {
        private final StoreAccess access;

        IndexSamplingManagerImpl(ManagementData management) throws NotCompliantMBeanException {
            super(management, new String[0]);
            this.access = IndexSamplingManagerBean.access(management);
        }

        IndexSamplingManagerImpl(ManagementData management, boolean mxBean) {
            super(management, mxBean, new String[0]);
            this.access = IndexSamplingManagerBean.access(management);
        }

        @Override
        public void triggerIndexSampling(String labelKey, String propertyKey, boolean forceSample) {
            this.access.triggerIndexSampling(labelKey, propertyKey, forceSample);
        }
    }
}

