/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import javax.management.NotCompliantMBeanException;
import org.neo4j.io.pagecache.monitoring.PageCacheMonitor;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.management.PageCache;

public final class PageCacheBean
extends ManagementBeanProvider {
    public PageCacheBean() {
        super(PageCache.class);
    }

    protected Neo4jMBean createMBean(ManagementData management) throws NotCompliantMBeanException {
        return new PageCacheImpl(management);
    }

    private static class PageCacheImpl
    extends Neo4jMBean
    implements PageCache {
        private final PageCacheMonitor pageCacheMonitor;

        PageCacheImpl(ManagementData management) throws NotCompliantMBeanException {
            super(management, new String[0]);
            this.pageCacheMonitor = (PageCacheMonitor)management.resolveDependency(PageCacheMonitor.class);
        }

        @Override
        public long getFaults() {
            return this.pageCacheMonitor.countFaults();
        }

        @Override
        public long getEvictions() {
            return this.pageCacheMonitor.countEvictions();
        }

        @Override
        public long getPins() {
            return this.pageCacheMonitor.countPins();
        }

        @Override
        public long getUnpins() {
            return this.pageCacheMonitor.countUnpins();
        }

        @Override
        public long getFlushes() {
            return this.pageCacheMonitor.countFlushes();
        }

        @Override
        public long getBytesRead() {
            return this.pageCacheMonitor.countBytesRead();
        }

        @Override
        public long getBytesWritten() {
            return this.pageCacheMonitor.countBytesWritten();
        }

        @Override
        public long getFileMappings() {
            return this.pageCacheMonitor.countFilesMapped();
        }

        @Override
        public long getFileUnmappings() {
            return this.pageCacheMonitor.countFilesUnmapped();
        }

        @Override
        public long getEvictionExceptions() {
            return this.pageCacheMonitor.countEvictionExceptions();
        }
    }
}

