/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import javax.management.NotCompliantMBeanException;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.transaction.TransactionCounters;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.management.TransactionManager;

public final class TransactionManagerBean
extends ManagementBeanProvider {
    public TransactionManagerBean() {
        super(TransactionManager.class);
    }

    protected Neo4jMBean createMBean(ManagementData management) throws NotCompliantMBeanException {
        return new TransactionManagerImpl(management);
    }

    private static class TransactionManagerImpl
    extends Neo4jMBean
    implements TransactionManager {
        private final TransactionCounters txMonitor;
        private final DataSourceManager xadsm;

        TransactionManagerImpl(ManagementData management) throws NotCompliantMBeanException {
            super(management, new String[0]);
            this.txMonitor = (TransactionCounters)management.resolveDependency(TransactionCounters.class);
            this.xadsm = (DataSourceManager)management.resolveDependency(DataSourceManager.class);
        }

        @Override
        public long getNumberOfOpenTransactions() {
            return this.txMonitor.getNumberOfActiveTransactions();
        }

        @Override
        public long getPeakNumberOfConcurrentTransactions() {
            return this.txMonitor.getPeakConcurrentNumberOfTransactions();
        }

        @Override
        public long getNumberOfOpenedTransactions() {
            return this.txMonitor.getNumberOfStartedTransactions();
        }

        @Override
        public long getNumberOfCommittedTransactions() {
            return this.txMonitor.getNumberOfCommittedTransactions();
        }

        @Override
        public long getNumberOfRolledBackTransactions() {
            return this.txMonitor.getNumberOfRolledbackTransactions();
        }

        @Override
        public long getLastCommittedTxId() {
            NeoStoreDataSource neoStoreDataSource = this.xadsm.getDataSource();
            if (neoStoreDataSource == null) {
                return -1L;
            }
            return neoStoreDataSource.getNeoStore().getLastCommittedTransactionId();
        }
    }
}

