/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl.jconsole;

import com.sun.tools.jconsole.JConsolePlugin;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.neo4j.management.HighAvailability;
import org.neo4j.management.RemoteConnection;
import org.neo4j.management.impl.jconsole.DataBrowser;
import org.neo4j.management.impl.jconsole.HaWidget;
import org.neo4j.management.impl.jconsole.KernelWidget;
import org.neo4j.management.impl.jconsole.ManagementAccess;
import org.neo4j.management.impl.jconsole.UpdateEvent;
import org.neo4j.management.impl.jconsole.Widget;

public class Neo4jPlugin
extends JConsolePlugin {
    private final Collection<Widget> widgets = new LinkedList<Widget>();

    @Override
    public Map<String, JPanel> getTabs() {
        ManagementAccess[] managers = ManagementAccess.getAll(this.getContext().getMBeanServerConnection());
        LinkedHashMap<String, JPanel> result = new LinkedHashMap<String, JPanel>();
        if (managers.length == 1) {
            this.addTabs(managers[0], "", result);
        } else {
            for (ManagementAccess manager : managers) {
                this.addTabs(manager, " (" + manager.getMBeanQuery().getKeyProperty("instance") + ")", result);
            }
        }
        return result;
    }

    private void addTabs(ManagementAccess manager, String suffix, Map<String, JPanel> result) {
        result.put("Neo4j" + suffix, this.add(new KernelWidget(manager)));
        try {
            HighAvailability ha = manager.getBean(HighAvailability.class);
            if (ha != null) {
                result.put("Neo4j HA" + suffix, this.add(new HaWidget(manager, ha)));
            }
        }
        catch (Exception haNotAvailable) {
            // empty catch block
        }
        try {
            RemoteConnection remote = manager.getBean(RemoteConnection.class);
            if (remote != null) {
                DataBrowser browser = new DataBrowser(remote);
                result.put("Neo4j Graph" + suffix, browser.view());
            }
        }
        catch (LinkageError dataBrowserNotAvailable) {
        }
        catch (Exception dataBrowserNotAvailable) {
            // empty catch block
        }
    }

    private JPanel add(Widget tab) {
        this.widgets.add(tab);
        return tab.view();
    }

    @Override
    public void dispose() {
        for (Widget widget : this.widgets) {
            widget.dispose();
        }
        super.dispose();
    }

    @Override
    public SwingWorker<?, ?> newSwingWorker() {
        return new SwingWorker<Void, UpdateEvent>(){

            @Override
            protected Void doInBackground() throws Exception {
                Iterator widget = Neo4jPlugin.this.widgets.iterator();
                int i = 0;
                while (widget.hasNext()) {
                    this.setProgress(100 * i / Neo4jPlugin.this.widgets.size());
                    UpdateEvent[] updates = ((Widget)widget.next()).update();
                    if (updates != null) {
                        this.publish(updates);
                    }
                    ++i;
                }
                this.setProgress(100);
                return null;
            }

            @Override
            protected void process(List<UpdateEvent> events) {
                for (UpdateEvent event : events) {
                    event.apply();
                }
            }
        };
    }
}

