/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.output;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.neo4j.io.IOUtils;
import org.neo4j.logging.RotatingFileOutputStreamSupplier;

public class RotatableCsvReporter
extends ScheduledReporter {
    private final Locale locale;
    private final Clock clock;
    private final File directory;
    private final Map<File, CsvRotatableWriter> writers;
    private final BiFunction<File, RotatingFileOutputStreamSupplier.RotationListener, RotatingFileOutputStreamSupplier> fileSupplierStreamCreator;

    RotatableCsvReporter(MetricRegistry registry, Locale locale, TimeUnit rateUnit, TimeUnit durationUnit, Clock clock, File directory, BiFunction<File, RotatingFileOutputStreamSupplier.RotationListener, RotatingFileOutputStreamSupplier> fileSupplierStreamCreator) {
        super(registry, "csv-reporter", MetricFilter.ALL, rateUnit, durationUnit);
        this.locale = locale;
        this.clock = clock;
        this.directory = directory;
        this.fileSupplierStreamCreator = fileSupplierStreamCreator;
        this.writers = new ConcurrentHashMap<File, CsvRotatableWriter>();
    }

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    public void stop() {
        super.stop();
        this.writers.values().forEach(CsvRotatableWriter::close);
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        long timestamp = TimeUnit.MILLISECONDS.toSeconds(this.clock.getTime());
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            this.reportGauge(timestamp, entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            this.reportCounter(timestamp, entry.getKey(), (Counter)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            this.reportHistogram(timestamp, entry.getKey(), (Histogram)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            this.reportMeter(timestamp, entry.getKey(), (Meter)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            this.reportTimer(timestamp, entry.getKey(), (Timer)entry.getValue());
        }
    }

    private void reportTimer(long timestamp, String name, Timer timer) {
        Snapshot snapshot = timer.getSnapshot();
        this.report(timestamp, name, "count,max,mean,min,stddev,p50,p75,p95,p98,p99,p999,mean_rate,m1_rate,m5_rate,m15_rate,rate_unit,duration_unit", "%d,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,calls/%s,%s", timer.getCount(), this.convertDuration(snapshot.getMax()), this.convertDuration(snapshot.getMean()), this.convertDuration(snapshot.getMin()), this.convertDuration(snapshot.getStdDev()), this.convertDuration(snapshot.getMedian()), this.convertDuration(snapshot.get75thPercentile()), this.convertDuration(snapshot.get95thPercentile()), this.convertDuration(snapshot.get98thPercentile()), this.convertDuration(snapshot.get99thPercentile()), this.convertDuration(snapshot.get999thPercentile()), this.convertRate(timer.getMeanRate()), this.convertRate(timer.getOneMinuteRate()), this.convertRate(timer.getFiveMinuteRate()), this.convertRate(timer.getFifteenMinuteRate()), this.getRateUnit(), this.getDurationUnit());
    }

    private void reportMeter(long timestamp, String name, Meter meter) {
        this.report(timestamp, name, "count,mean_rate,m1_rate,m5_rate,m15_rate,rate_unit", "%d,%f,%f,%f,%f,events/%s", meter.getCount(), this.convertRate(meter.getMeanRate()), this.convertRate(meter.getOneMinuteRate()), this.convertRate(meter.getFiveMinuteRate()), this.convertRate(meter.getFifteenMinuteRate()), this.getRateUnit());
    }

    private void reportHistogram(long timestamp, String name, Histogram histogram) {
        Snapshot snapshot = histogram.getSnapshot();
        this.report(timestamp, name, "count,max,mean,min,stddev,p50,p75,p95,p98,p99,p999", "%d,%d,%f,%d,%f,%f,%f,%f,%f,%f,%f", histogram.getCount(), snapshot.getMax(), snapshot.getMean(), snapshot.getMin(), snapshot.getStdDev(), snapshot.getMedian(), snapshot.get75thPercentile(), snapshot.get95thPercentile(), snapshot.get98thPercentile(), snapshot.get99thPercentile(), snapshot.get999thPercentile());
    }

    private void reportCounter(long timestamp, String name, Counter counter) {
        this.report(timestamp, name, "count", "%d", counter.getCount());
    }

    private void reportGauge(long timestamp, String name, Gauge gauge) {
        this.report(timestamp, name, "value", "%s", gauge.getValue());
    }

    private void report(long timestamp, String name, String header, String line, Object ... values) {
        File file = new File(this.directory, name + ".csv");
        CsvRotatableWriter csvRotatableWriter = this.writers.computeIfAbsent(file, new RotatingCsvWriterSupplier(header, this.fileSupplierStreamCreator, this.writers));
        csvRotatableWriter.writeValues(this.locale, timestamp, line, values);
    }

    private static class CsvRotatableWriter {
        private final PrintWriter printWriter;
        private final RotatingFileOutputStreamSupplier streamSupplier;

        CsvRotatableWriter(PrintWriter printWriter, RotatingFileOutputStreamSupplier streamSupplier) {
            this.printWriter = printWriter;
            this.streamSupplier = streamSupplier;
        }

        void close() {
            IOUtils.closeAllSilently((AutoCloseable[])new Closeable[]{this.printWriter, this.streamSupplier});
        }

        synchronized void writeValues(Locale locale, long timestamp, String line, Object[] values) {
            this.streamSupplier.get();
            this.printWriter.printf(locale, String.format(locale, "%d,%s%n", timestamp, line), values);
            this.printWriter.flush();
        }
    }

    private static class RotatingCsvWriterSupplier
    implements Function<File, CsvRotatableWriter> {
        private final String header;
        private final BiFunction<File, RotatingFileOutputStreamSupplier.RotationListener, RotatingFileOutputStreamSupplier> fileSupplierStreamCreator;
        private final Map<File, CsvRotatableWriter> writers;

        RotatingCsvWriterSupplier(String header, BiFunction<File, RotatingFileOutputStreamSupplier.RotationListener, RotatingFileOutputStreamSupplier> fileSupplierStreamCreator, Map<File, CsvRotatableWriter> writers) {
            this.header = header;
            this.fileSupplierStreamCreator = fileSupplierStreamCreator;
            this.writers = writers;
        }

        @Override
        public CsvRotatableWriter apply(File file) {
            RotatingFileOutputStreamSupplier outputStreamSupplier = this.fileSupplierStreamCreator.apply(file, new HeaderWriterRotationListener());
            PrintWriter printWriter = RotatingCsvWriterSupplier.createWriter(outputStreamSupplier.get());
            CsvRotatableWriter writer = new CsvRotatableWriter(printWriter, outputStreamSupplier);
            RotatingCsvWriterSupplier.writeHeader(printWriter, this.header);
            return writer;
        }

        private static PrintWriter createWriter(OutputStream outputStream) {
            return new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
        }

        private static void writeHeader(PrintWriter printWriter, String header) {
            printWriter.println("t," + header);
            printWriter.flush();
        }

        private class HeaderWriterRotationListener
        extends RotatingFileOutputStreamSupplier.RotationListener {
            private HeaderWriterRotationListener() {
            }

            public void rotationCompleted(OutputStream out) {
                super.rotationCompleted(out);
                try (PrintWriter writer = RotatingCsvWriterSupplier.createWriter(out);){
                    RotatingCsvWriterSupplier.writeHeader(writer, RotatingCsvWriterSupplier.this.header);
                }
            }
        }
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Locale locale;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private Clock clock;
        private BiFunction<File, RotatingFileOutputStreamSupplier.RotationListener, RotatingFileOutputStreamSupplier> outputStreamSupplierFactory;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.locale = Locale.getDefault();
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.clock = Clock.defaultClock();
        }

        public Builder formatFor(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder outputStreamSupplierFactory(BiFunction<File, RotatingFileOutputStreamSupplier.RotationListener, RotatingFileOutputStreamSupplier> outputStreamSupplierFactory) {
            this.outputStreamSupplierFactory = outputStreamSupplierFactory;
            return this;
        }

        public RotatableCsvReporter build(File directory) {
            return new RotatableCsvReporter(this.registry, this.locale, this.rateUnit, this.durationUnit, this.clock, directory, this.outputStreamSupplierFactory);
        }
    }
}

