/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source.causalclustering;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.util.function.Supplier;
import org.neo4j.causalclustering.core.consensus.CoreMetaData;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.metrics.source.causalclustering.InFlightCacheMetric;
import org.neo4j.metrics.source.causalclustering.LeaderNotFoundMetric;
import org.neo4j.metrics.source.causalclustering.MessageQueueMonitorMetric;
import org.neo4j.metrics.source.causalclustering.RaftLogAppendIndexMetric;
import org.neo4j.metrics.source.causalclustering.RaftLogCommitIndexMetric;
import org.neo4j.metrics.source.causalclustering.RaftTermMetric;
import org.neo4j.metrics.source.causalclustering.TxPullRequestsMetric;
import org.neo4j.metrics.source.causalclustering.TxRetryMetric;

@Documented(value=".Core Metrics")
public class CoreMetrics
extends LifecycleAdapter {
    private static final String CAUSAL_CLUSTERING_PREFIX = "neo4j.causal_clustering.core";
    @Documented(value="Append index of the RAFT log")
    public static final String APPEND_INDEX = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"append_index"});
    @Documented(value="Commit index of the RAFT log")
    public static final String COMMIT_INDEX = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"commit_index"});
    @Documented(value="RAFT Term of this server")
    public static final String TERM = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"term"});
    @Documented(value="Leader was not found while attempting to commit a transaction")
    public static final String LEADER_NOT_FOUND = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"leader_not_found"});
    @Documented(value="Transaction retries")
    public static final String TX_RETRIES = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"tx_retries"});
    @Documented(value="Is this server the leader?")
    public static final String IS_LEADER = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"is_leader"});
    @Documented(value="How many RAFT messages were dropped?")
    public static final String DROPPED_MESSAGES = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"dropped_messages"});
    @Documented(value="How many RAFT messages are queued up?")
    public static final String QUEUE_SIZE = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"queue_sizes"});
    @Documented(value="In-flight cache total bytes")
    public static final String TOTAL_BYTES = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"in_flight_cache", "total_bytes"});
    @Documented(value="In-flight cache max bytes")
    public static final String MAX_BYTES = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"in_flight_cache", "max_bytes"});
    @Documented(value="In-flight cache element count")
    public static final String ELEMENT_COUNT = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"in_flight_cache", "element_count"});
    @Documented(value="In-flight cache maximum elements")
    public static final String MAX_ELEMENTS = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"in_flight_cache", "max_elements"});
    @Documented(value="In-flight cache hits")
    public static final String HITS = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"in_flight_cache", "hits"});
    @Documented(value="In-flight cache misses")
    public static final String MISSES = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"in_flight_cache", "misses"});
    private Monitors monitors;
    private MetricRegistry registry;
    private Supplier<CoreMetaData> coreMetaData;
    private final RaftLogCommitIndexMetric raftLogCommitIndexMetric = new RaftLogCommitIndexMetric();
    private final RaftLogAppendIndexMetric raftLogAppendIndexMetric = new RaftLogAppendIndexMetric();
    private final RaftTermMetric raftTermMetric = new RaftTermMetric();
    private final LeaderNotFoundMetric leaderNotFoundMetric = new LeaderNotFoundMetric();
    private final TxPullRequestsMetric txPullRequestsMetric = new TxPullRequestsMetric();
    private final TxRetryMetric txRetryMetric = new TxRetryMetric();
    private final MessageQueueMonitorMetric messageQueueMetric = new MessageQueueMonitorMetric();
    private final InFlightCacheMetric inFlightCacheMetric = new InFlightCacheMetric();

    public CoreMetrics(Monitors monitors, MetricRegistry registry, Supplier<CoreMetaData> coreMetaData) {
        this.monitors = monitors;
        this.registry = registry;
        this.coreMetaData = coreMetaData;
    }

    public void start() throws Throwable {
        this.monitors.addMonitorListener((Object)this.raftLogCommitIndexMetric, new String[0]);
        this.monitors.addMonitorListener((Object)this.raftLogAppendIndexMetric, new String[0]);
        this.monitors.addMonitorListener((Object)this.raftTermMetric, new String[0]);
        this.monitors.addMonitorListener((Object)this.leaderNotFoundMetric, new String[0]);
        this.monitors.addMonitorListener((Object)this.txPullRequestsMetric, new String[0]);
        this.monitors.addMonitorListener((Object)this.txRetryMetric, new String[0]);
        this.monitors.addMonitorListener((Object)this.messageQueueMetric, new String[0]);
        this.monitors.addMonitorListener((Object)this.inFlightCacheMetric, new String[0]);
        this.registry.register(COMMIT_INDEX, (Metric)((Gauge)this.raftLogCommitIndexMetric::commitIndex));
        this.registry.register(APPEND_INDEX, (Metric)((Gauge)this.raftLogAppendIndexMetric::appendIndex));
        this.registry.register(TERM, (Metric)((Gauge)this.raftTermMetric::term));
        this.registry.register(LEADER_NOT_FOUND, (Metric)((Gauge)this.leaderNotFoundMetric::leaderNotFoundExceptions));
        this.registry.register(TX_RETRIES, (Metric)((Gauge)this.txRetryMetric::transactionsRetries));
        this.registry.register(IS_LEADER, (Metric)new LeaderGauge());
        this.registry.register(DROPPED_MESSAGES, (Metric)((Gauge)this.messageQueueMetric::droppedMessages));
        this.registry.register(QUEUE_SIZE, (Metric)((Gauge)this.messageQueueMetric::queueSizes));
        this.registry.register(TOTAL_BYTES, (Metric)((Gauge)this.inFlightCacheMetric::getTotalBytes));
        this.registry.register(HITS, (Metric)((Gauge)this.inFlightCacheMetric::getHits));
        this.registry.register(MISSES, (Metric)((Gauge)this.inFlightCacheMetric::getMisses));
        this.registry.register(MAX_BYTES, (Metric)((Gauge)this.inFlightCacheMetric::getMaxBytes));
        this.registry.register(MAX_ELEMENTS, (Metric)((Gauge)this.inFlightCacheMetric::getMaxElements));
        this.registry.register(ELEMENT_COUNT, (Metric)((Gauge)this.inFlightCacheMetric::getElementCount));
    }

    public void stop() throws IOException {
        this.registry.remove(COMMIT_INDEX);
        this.registry.remove(APPEND_INDEX);
        this.registry.remove(TERM);
        this.registry.remove(LEADER_NOT_FOUND);
        this.registry.remove(TX_RETRIES);
        this.registry.remove(IS_LEADER);
        this.registry.remove(DROPPED_MESSAGES);
        this.registry.remove(QUEUE_SIZE);
        this.registry.remove(TOTAL_BYTES);
        this.registry.remove(HITS);
        this.registry.remove(MISSES);
        this.registry.remove(MAX_BYTES);
        this.registry.remove(MAX_ELEMENTS);
        this.registry.remove(ELEMENT_COUNT);
        this.monitors.removeMonitorListener((Object)this.raftLogCommitIndexMetric);
        this.monitors.removeMonitorListener((Object)this.raftLogAppendIndexMetric);
        this.monitors.removeMonitorListener((Object)this.raftTermMetric);
        this.monitors.removeMonitorListener((Object)this.leaderNotFoundMetric);
        this.monitors.removeMonitorListener((Object)this.txPullRequestsMetric);
        this.monitors.removeMonitorListener((Object)this.txRetryMetric);
        this.monitors.removeMonitorListener((Object)this.messageQueueMetric);
        this.monitors.removeMonitorListener((Object)this.inFlightCacheMetric);
    }

    private class LeaderGauge
    implements Gauge<Integer> {
        private LeaderGauge() {
        }

        public Integer getValue() {
            return ((CoreMetaData)CoreMetrics.this.coreMetaData.get()).isLeader() ? 1 : 0;
        }
    }
}

