/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source.db;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.bolt.v1.runtime.MonitoredWorkerFactory;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;

@Documented(value=".Bolt Metrics")
public class BoltMetrics
extends LifecycleAdapter {
    private static final String NAME_PREFIX = "neo4j.bolt";
    @Documented(value="The total number of Bolt sessions started since this instance started. This includes both succeeded and failed sessions.")
    public static final String SESSIONS_STARTED = MetricRegistry.name((String)"neo4j.bolt", (String[])new String[]{"sessions_started"});
    @Documented(value="The total number of messages received via Bolt since this instance started.")
    public static final String MESSAGES_RECIEVED = MetricRegistry.name((String)"neo4j.bolt", (String[])new String[]{"messages_received"});
    @Documented(value="The total number of messages work has started on since this instance started. This is different from messages received in that this counter tracks how many of the received messages havebeen taken on by a worker thread.")
    public static final String MESSAGES_STARTED = MetricRegistry.name((String)"neo4j.bolt", (String[])new String[]{"messages_started"});
    @Documented(value="The total number of messages work has completed on since this instance started. This includes successful, failed and ignored Bolt messages.")
    public static final String MESSAGES_DONE = MetricRegistry.name((String)"neo4j.bolt", (String[])new String[]{"messages_done"});
    @Documented(value="The accumulated time messages have spent waiting for a worker thread.")
    public static final String TOTAL_QUEUE_TIME = MetricRegistry.name((String)"neo4j.bolt", (String[])new String[]{"accumulated_queue_time"});
    @Documented(value="The accumulated time worker threads have spent processing messages.")
    public static final String TOTAL_PROCESSING_TIME = MetricRegistry.name((String)"neo4j.bolt", (String[])new String[]{"accumulated_processing_time"});
    private final MetricRegistry registry;
    private final Monitors monitors;
    private final BoltMetricsMonitor boltMonitor = new BoltMetricsMonitor();

    public BoltMetrics(MetricRegistry registry, Monitors monitors) {
        this.registry = registry;
        this.monitors = monitors;
    }

    public void start() {
        this.monitors.addMonitorListener((Object)this.boltMonitor, new String[0]);
        this.registry.register(SESSIONS_STARTED, (Metric)((Gauge)this.boltMonitor.sessionsStarted::get));
        this.registry.register(MESSAGES_RECIEVED, (Metric)((Gauge)this.boltMonitor.messagesReceived::get));
        this.registry.register(MESSAGES_STARTED, (Metric)((Gauge)this.boltMonitor.messagesStarted::get));
        this.registry.register(MESSAGES_DONE, (Metric)((Gauge)this.boltMonitor.messagesDone::get));
        this.registry.register(TOTAL_QUEUE_TIME, (Metric)((Gauge)this.boltMonitor.queueTime::get));
        this.registry.register(TOTAL_PROCESSING_TIME, (Metric)((Gauge)this.boltMonitor.processingTime::get));
    }

    public void stop() {
        this.registry.remove(MESSAGES_RECIEVED);
        this.registry.remove(MESSAGES_STARTED);
        this.registry.remove(MESSAGES_DONE);
        this.registry.remove(TOTAL_QUEUE_TIME);
        this.registry.remove(TOTAL_PROCESSING_TIME);
        this.monitors.removeMonitorListener((Object)this.boltMonitor);
    }

    private class BoltMetricsMonitor
    implements MonitoredWorkerFactory.SessionMonitor {
        final AtomicLong sessionsStarted = new AtomicLong();
        final AtomicLong messagesReceived = new AtomicLong();
        final AtomicLong messagesStarted = new AtomicLong();
        final AtomicLong messagesDone = new AtomicLong();
        final AtomicLong queueTime = new AtomicLong();
        final AtomicLong processingTime = new AtomicLong();

        private BoltMetricsMonitor() {
        }

        public void sessionStarted() {
            this.sessionsStarted.incrementAndGet();
        }

        public void messageReceived() {
            this.messagesReceived.incrementAndGet();
        }

        public void processingStarted(long queueTime) {
            this.queueTime.addAndGet(queueTime);
            this.messagesStarted.incrementAndGet();
        }

        public void processingDone(long processingTime) {
            this.processingTime.addAndGet(processingTime);
            this.messagesDone.incrementAndGet();
        }
    }
}

