/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source.db;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.impl.store.stats.StoreEntityCounters;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

@Documented(value=".Database Data Metrics")
public class EntityCountMetrics
extends LifecycleAdapter {
    private static final String COUNTS_PREFIX = "neo4j.ids_in_use";
    @Documented(value="The total number of different relationship types stored in the database")
    public static final String COUNTS_RELATIONSHIP_TYPE = MetricRegistry.name((String)"neo4j.ids_in_use", (String[])new String[]{"relationship_type"});
    @Documented(value="The total number of different property names used in the database")
    public static final String COUNTS_PROPERTY = MetricRegistry.name((String)"neo4j.ids_in_use", (String[])new String[]{"property"});
    @Documented(value="The total number of relationships stored in the database")
    public static final String COUNTS_RELATIONSHIP = MetricRegistry.name((String)"neo4j.ids_in_use", (String[])new String[]{"relationship"});
    @Documented(value="The total number of nodes stored in the database")
    public static final String COUNTS_NODE = MetricRegistry.name((String)"neo4j.ids_in_use", (String[])new String[]{"node"});
    private final MetricRegistry registry;
    private final StoreEntityCounters storeEntityCounters;

    public EntityCountMetrics(MetricRegistry registry, StoreEntityCounters storeEntityCounters) {
        this.registry = registry;
        this.storeEntityCounters = storeEntityCounters;
    }

    public void start() {
        this.registry.register(COUNTS_NODE, (Metric)((Gauge)() -> ((StoreEntityCounters)this.storeEntityCounters).nodes()));
        this.registry.register(COUNTS_RELATIONSHIP, (Metric)((Gauge)() -> ((StoreEntityCounters)this.storeEntityCounters).relationships()));
        this.registry.register(COUNTS_PROPERTY, (Metric)((Gauge)() -> ((StoreEntityCounters)this.storeEntityCounters).properties()));
        this.registry.register(COUNTS_RELATIONSHIP_TYPE, (Metric)((Gauge)() -> ((StoreEntityCounters)this.storeEntityCounters).relationshipTypes()));
    }

    public void stop() {
        this.registry.remove(COUNTS_NODE);
        this.registry.remove(COUNTS_RELATIONSHIP);
        this.registry.remove(COUNTS_PROPERTY);
        this.registry.remove(COUNTS_RELATIONSHIP_TYPE);
    }
}

