/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ext.monitorlogging;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Predicate;
import org.neo4j.kernel.monitoring.MonitorListenerInvocationHandler;
import org.neo4j.logging.Logger;

public class LoggingListener
implements MonitorListenerInvocationHandler {
    private final Map<Class<?>, Logger> classes;
    public final Predicate<Method> predicate = new Predicate<Method>(){

        @Override
        public boolean test(Method item) {
            Class<?> clazz = item.getDeclaringClass();
            return LoggingListener.this.classes.containsKey(clazz);
        }
    };

    public LoggingListener(Map<Class<?>, Logger> classes) {
        assert (classes != null);
        this.classes = classes;
    }

    public void invoke(Object proxy, Method method, Object[] args, String ... tags) throws Throwable {
        Class<?> clazz = method.getDeclaringClass();
        StringBuilder stringBuilder = new StringBuilder().append(method.getName());
        this.formatArguments(stringBuilder, args, method.getParameterTypes());
        this.classes.get(clazz).log(stringBuilder.toString());
    }

    private void formatArguments(StringBuilder stringBuilder, Object[] args, Class<?>[] types) {
        stringBuilder.append("(");
        for (int i = 0; args != null && i < args.length; ++i) {
            (i > 0 ? stringBuilder.append(",") : stringBuilder).append(types[i].getSimpleName()).append(":").append(args[i]);
        }
        stringBuilder.append(")");
    }
}

