/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ext.monitorlogging;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.neo4j.ext.monitorlogging.LoggingListener;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.MonitorListenerInvocationHandler;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;

public class MonitorLoggingExtension
implements Lifecycle {
    private final Properties props;
    private final LogService logService;
    private final Log log;
    private final Monitors monitors;

    public MonitorLoggingExtension(Properties props, LogService logService, Monitors monitors) {
        this.props = props;
        this.logService = logService;
        this.log = logService.getInternalLog(this.getClass());
        this.monitors = monitors;
    }

    public void init() throws Throwable {
        Set<Map.Entry<Object, Object>> classes = this.props.entrySet();
        if (classes.isEmpty()) {
            return;
        }
        HashMap clazzez = new HashMap(classes.size());
        block14: for (Map.Entry<Object, Object> entry : classes) {
            Logger logger;
            Class<?> clazz;
            String className = (String)entry.getKey();
            String logLevel = (String)entry.getValue();
            try {
                clazz = this.getClass().getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                this.log.warn("When trying to add a logging monitor, not able to load class " + className, (Throwable)ex);
                continue;
            }
            Log classLog = this.logService.getInternalLog(clazz);
            switch (logLevel) {
                case "DEBUG": {
                    logger = classLog.debugLogger();
                    break;
                }
                case "INFO": {
                    logger = classLog.infoLogger();
                    break;
                }
                case "WARN": {
                    logger = classLog.warnLogger();
                    break;
                }
                case "ERROR": {
                    logger = classLog.errorLogger();
                    break;
                }
                default: {
                    this.log.warn("When trying to add a logging monitor for %s not able to understand the log level, got %s", new Object[]{className, logLevel});
                    continue block14;
                }
            }
            clazzez.put(clazz, logger);
        }
        if (clazzez.isEmpty()) {
            return;
        }
        LoggingListener listener = new LoggingListener(clazzez);
        this.monitors.addMonitorListener((MonitorListenerInvocationHandler)listener, listener.predicate);
    }

    public void start() throws Throwable {
    }

    public void stop() throws Throwable {
    }

    public void shutdown() throws Throwable {
    }
}

