/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ext.monitorlogging;

import java.io.InputStream;
import java.util.Properties;
import org.neo4j.ext.monitorlogging.MonitorLoggingExtension;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;

public class MonitorLoggingExtensionFactory
extends KernelExtensionFactory<Dependencies> {
    static final String KEY = "kernel monitor logging";
    private static final String filename = "/org/neo4j/ext/monitorlogging/monitorlogging.properties";

    public MonitorLoggingExtensionFactory() {
        super(KEY);
    }

    public Lifecycle newInstance(KernelContext context, Dependencies dependencies) throws Throwable {
        LogService logService = dependencies.getLogService();
        Properties props = this.loadProperties(logService);
        return new MonitorLoggingExtension(props, logService, dependencies.getMonitors());
    }

    private Properties loadProperties(LogService logService) {
        Properties props = new Properties();
        try {
            InputStream resource = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
            if (resource != null) {
                props.load(resource);
            }
        }
        catch (Exception e) {
            logService.getInternalLog(((Object)((Object)this)).getClass()).warn("Unable to read the log monitors property file: /org/neo4j/ext/monitorlogging/monitorlogging.properties", (Throwable)e);
        }
        return props;
    }

    public static interface Dependencies {
        public LogService getLogService();

        public Monitors getMonitors();
    }
}

