/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.monitoring;

import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.monitoring.VmPauseMonitor;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;

class VmPauseMonitorTest {
    private final VmPauseMonitor.Monitor monitor = (VmPauseMonitor.Monitor)Mockito.mock(VmPauseMonitor.Monitor.class);
    private final JobHandle jobHandle = (JobHandle)Mockito.mock(JobHandle.class);
    private final JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
    private final VmPauseMonitor vmPauseMonitor = (VmPauseMonitor)Mockito.spy((Object)new VmPauseMonitor(Duration.ofMillis(1L), Duration.ofMillis(0L), this.monitor, this.jobScheduler));

    VmPauseMonitorTest() {
    }

    @BeforeEach
    void setUp() {
        ((JobScheduler)Mockito.doReturn((Object)this.jobHandle).when((Object)this.jobScheduler)).schedule((Group)ArgumentMatchers.any(Group.class), (JobMonitoringParams)ArgumentMatchers.eq((Object)JobMonitoringParams.NOT_MONITORED), (Runnable)ArgumentMatchers.any(Runnable.class));
    }

    @Test
    void testCtorParametersValidation() {
        Assertions.assertThrows(NullPointerException.class, () -> new VmPauseMonitor(Duration.ofSeconds(1L), Duration.ofSeconds(1L), null, this.jobScheduler));
        Assertions.assertThrows(NullPointerException.class, () -> new VmPauseMonitor(Duration.ofSeconds(1L), Duration.ofSeconds(1L), VmPauseMonitor.Monitor.EMPTY, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new VmPauseMonitor(Duration.ofSeconds(0L), Duration.ofSeconds(1L), VmPauseMonitor.Monitor.EMPTY, this.jobScheduler));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new VmPauseMonitor(Duration.ofSeconds(1L), Duration.ofSeconds(-1L), VmPauseMonitor.Monitor.EMPTY, this.jobScheduler));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new VmPauseMonitor(Duration.ofSeconds(-1L), Duration.ofSeconds(1L), VmPauseMonitor.Monitor.EMPTY, this.jobScheduler));
    }

    @Test
    void testStartAndStop() {
        this.vmPauseMonitor.start();
        this.vmPauseMonitor.stop();
        ((JobScheduler)Mockito.verify((Object)this.jobScheduler)).schedule((Group)ArgumentMatchers.any(Group.class), (JobMonitoringParams)ArgumentMatchers.eq((Object)JobMonitoringParams.NOT_MONITORED), (Runnable)ArgumentMatchers.any(Runnable.class));
        ((JobHandle)Mockito.verify((Object)this.jobHandle)).cancel();
    }

    @Test
    void testRestart() {
        this.vmPauseMonitor.start();
        this.vmPauseMonitor.stop();
        this.vmPauseMonitor.start();
        ((JobScheduler)Mockito.verify((Object)this.jobScheduler, (VerificationMode)Mockito.times((int)2))).schedule((Group)ArgumentMatchers.any(Group.class), (JobMonitoringParams)ArgumentMatchers.eq((Object)JobMonitoringParams.NOT_MONITORED), (Runnable)ArgumentMatchers.any(Runnable.class));
        ((JobHandle)Mockito.verify((Object)this.jobHandle)).cancel();
    }

    @Test
    void testFailStopWithoutStart() {
        Assertions.assertThrows(IllegalStateException.class, () -> ((VmPauseMonitor)this.vmPauseMonitor).stop());
    }

    @Test
    void testFailOnDoubleStart() {
        Assertions.assertThrows(IllegalStateException.class, () -> {
            this.vmPauseMonitor.start();
            this.vmPauseMonitor.start();
        });
    }

    @Test
    void testFailOnDoubleStop() {
        Assertions.assertThrows(IllegalStateException.class, () -> {
            this.vmPauseMonitor.start();
            this.vmPauseMonitor.stop();
            this.vmPauseMonitor.stop();
        });
    }

    @Test
    void testNotifyListener() throws Exception {
        ((VmPauseMonitor)Mockito.doReturn((Object)false, (Object[])new Object[]{true}).when((Object)this.vmPauseMonitor)).isStopped();
        this.vmPauseMonitor.monitor();
        ((VmPauseMonitor.Monitor)Mockito.verify((Object)this.monitor)).pauseDetected((VmPauseMonitor.VmPauseInfo)ArgumentMatchers.any(VmPauseMonitor.VmPauseInfo.class));
    }
}

