/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.monitoring;

import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.monitoring.Monitors;

class MonitorsTest {
    MonitorsTest() {
    }

    @Test
    void shouldProvideNoOpDelegate() {
        Monitors monitors = new Monitors();
        MyMonitor monitor = (MyMonitor)monitors.newMonitor(MyMonitor.class, new String[0]);
        monitor.aVoid();
        monitor.takesArgs("ha", 12L, new Object());
    }

    @Test
    void shouldRegister() {
        Monitors monitors = new Monitors();
        MyMonitor listener = (MyMonitor)Mockito.mock(MyMonitor.class);
        MyMonitor monitor = (MyMonitor)monitors.newMonitor(MyMonitor.class, new String[0]);
        Object obj = new Object();
        monitors.addMonitorListener((Object)listener, new String[0]);
        monitor.aVoid();
        monitor.takesArgs("ha", 12L, obj);
        ((MyMonitor)Mockito.verify((Object)listener)).aVoid();
        ((MyMonitor)Mockito.verify((Object)listener)).takesArgs("ha", 12L, obj);
    }

    @Test
    void shouldUnregister() {
        Monitors monitors = new Monitors();
        MyMonitor listener = (MyMonitor)Mockito.mock(MyMonitor.class);
        MyMonitor monitor = (MyMonitor)monitors.newMonitor(MyMonitor.class, new String[0]);
        Object obj = new Object();
        monitors.addMonitorListener((Object)listener, new String[0]);
        monitors.removeMonitorListener((Object)listener);
        monitor.aVoid();
        monitor.takesArgs("ha", 12L, obj);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    void shouldRespectTags() {
        Monitors monitors = new Monitors();
        MyMonitor listener = (MyMonitor)Mockito.mock(MyMonitor.class);
        MyMonitor monitorTag1 = (MyMonitor)monitors.newMonitor(MyMonitor.class, new String[]{"tag1"});
        MyMonitor monitorTag2 = (MyMonitor)monitors.newMonitor(MyMonitor.class, new String[]{"tag2"});
        monitors.addMonitorListener((Object)listener, new String[]{"tag2"});
        monitorTag1.aVoid();
        Mockito.verifyNoInteractions((Object[])new Object[]{listener});
        monitorTag2.aVoid();
        ((MyMonitor)Mockito.verify((Object)listener)).aVoid();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    void eventShouldBubbleUp() {
        Monitors parent = new Monitors();
        MyMonitor parentListener = (MyMonitor)Mockito.mock(MyMonitor.class);
        parent.addMonitorListener((Object)parentListener, new String[0]);
        Monitors child = new Monitors(parent, (LogProvider)NullLogProvider.getInstance());
        MyMonitor childListener = (MyMonitor)Mockito.mock(MyMonitor.class);
        child.addMonitorListener((Object)childListener, new String[0]);
        MyMonitor parentMonitor = (MyMonitor)parent.newMonitor(MyMonitor.class, new String[0]);
        parentMonitor.aVoid();
        ((MyMonitor)Mockito.verify((Object)parentListener)).aVoid();
        Mockito.verifyNoInteractions((Object[])new Object[]{childListener});
        MyMonitor childMonitor = (MyMonitor)child.newMonitor(MyMonitor.class, new String[0]);
        childMonitor.aVoid();
        ((MyMonitor)Mockito.verify((Object)parentListener, (VerificationMode)Mockito.times((int)2))).aVoid();
        ((MyMonitor)Mockito.verify((Object)childListener)).aVoid();
    }

    static interface MyMonitor {
        public void aVoid();

        public void takesArgs(String var1, long var2, Object ... var4);
    }
}

