/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.http.request;

import com.github.paweladamski.httpclientmock.HttpClientMock;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.drivers.http.request.HttpRequest;
import org.neo4j.ogm.exception.ConnectionException;

public class HttpRequestTest {
    @Test
    public void shouldHandleErrorJsonResponseGracefully() {
        String failWithJsonUrl = "http://localhost/failWithJson";
        String validJsonResponse = "{\"errors\":[ {\"message\":\"This is an error\"},{\"message\":\"This is another error\"}]}";
        HttpClientMock httpClientMock = new HttpClientMock();
        httpClientMock.onGet("http://localhost/failWithJson").doReturn("{\"errors\":[ {\"message\":\"This is an error\"},{\"message\":\"This is another error\"}]}").withStatus(502).withHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        Assertions.assertThatExceptionOfType(ConnectionException.class).isThrownBy(() -> HttpRequest.execute((CloseableHttpClient)httpClientMock, (HttpRequestBase)new HttpGet("http://localhost/failWithJson"), null)).withRootCauseInstanceOf(HttpResponseException.class).withStackTraceContaining("This is an error");
    }

    @Test
    public void shouldHandleErrorNonJsonResponseGracefully() {
        String failWithHtmlUrl = "http://localhost/failWithHtml";
        String htmlResponse = "<!DOCTYPE html><html lang=\"en\"><head><meta charset=\"utf-8\"><title>Error</title></head><body><pre>Cannot POST /db/data/transaction/commit</pre></body></html> ";
        HttpClientMock httpClientMock = new HttpClientMock();
        httpClientMock.onGet("http://localhost/failWithHtml").doReturn("<!DOCTYPE html><html lang=\"en\"><head><meta charset=\"utf-8\"><title>Error</title></head><body><pre>Cannot POST /db/data/transaction/commit</pre></body></html> ").withStatus(502).withHeader("Content-Type", ContentType.TEXT_HTML.getMimeType());
        Assertions.assertThatExceptionOfType(ConnectionException.class).isThrownBy(() -> HttpRequest.execute((CloseableHttpClient)httpClientMock, (HttpRequestBase)new HttpGet("http://localhost/failWithHtml"), null)).withRootCauseInstanceOf(HttpResponseException.class).withStackTraceContaining("Could not parse the servers response as JSON");
    }
}

