/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.springframework.boot.autoconfigure;

import java.util.Collection;
import java.util.List;
import org.neo4j.driver.Driver;
import org.neo4j.ogm.config.AutoIndexMode;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.event.EventListener;
import org.neo4j.ogm.springframework.boot.autoconfigure.Neo4jOGMProperties;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.neo4j.Neo4jDataAutoConfiguration;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.boot.autoconfigure.neo4j.Neo4jAutoConfiguration;
import org.springframework.boot.autoconfigure.neo4j.Neo4jConnectionDetails;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.neo4j.transaction.Neo4jTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnClass(value={SessionFactory.class})
@ConditionalOnBean(value={Driver.class})
@AutoConfigureAfter(value={Neo4jAutoConfiguration.class})
@AutoConfigureBefore(value={Neo4jDataAutoConfiguration.class})
@EnableConfigurationProperties(value={Neo4jOGMProperties.class})
public class Neo4jOGMAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={PlatformTransactionManager.class})
    public Neo4jTransactionManager transactionManager(SessionFactory sessionFactory, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        Neo4jTransactionManager transactionManager = new Neo4jTransactionManager(sessionFactory);
        transactionManagerCustomizers.ifAvailable(customizers -> customizers.customize((PlatformTransactionManager)transactionManager));
        return transactionManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public Configuration configuration(Neo4jConnectionDetails springBootNeo4jConnectionDetails, Neo4jOGMProperties ogmProperties) {
        Configuration.Builder builder = new Configuration.Builder().uri(springBootNeo4jConnectionDetails.getUri().toString());
        if (ogmProperties.isUseNativeTypes()) {
            builder.useNativeTypes();
        }
        if (ogmProperties.isUseStrictQuerying()) {
            builder.strictQuerying();
        }
        builder.withBasePackages(ogmProperties.getBasePackages());
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public BoltDriver ogmDriver(Configuration ogmConfiguration, Driver nativeDriver) {
        BoltDriver boltDriver = new BoltDriver(nativeDriver){

            public synchronized void close() {
            }
        };
        boltDriver.configure(ogmConfiguration);
        return boltDriver;
    }

    @Bean
    @ConditionalOnMissingBean(value={SessionFactory.class})
    SessionFactory sessionFactory(Configuration configuration, BoltDriver ogmDriver, BeanFactory beanFactory, ObjectProvider<EventListener> eventListeners) {
        String[] packages = configuration.getBasePackages();
        if (packages == null || packages.length == 0) {
            packages = this.getPackagesToScan(beanFactory);
        }
        SessionFactory sessionFactory = new SessionFactory((org.neo4j.ogm.driver.Driver)ogmDriver, packages);
        if (configuration.getAutoIndex() != AutoIndexMode.NONE) {
            sessionFactory.runAutoIndexManager(configuration);
        }
        eventListeners.orderedStream().forEach(arg_0 -> ((SessionFactory)sessionFactory).register(arg_0));
        return sessionFactory;
    }

    private String[] getPackagesToScan(BeanFactory beanFactory) {
        List packages = EntityScanPackages.get((BeanFactory)beanFactory).getPackageNames();
        if (packages.isEmpty() && AutoConfigurationPackages.has((BeanFactory)beanFactory)) {
            packages = AutoConfigurationPackages.get((BeanFactory)beanFactory);
        }
        return StringUtils.toStringArray((Collection)packages);
    }
}

