/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.onlinebackup;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.transaction.TxModule;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public class ApplyNewLogs {
    private static final String LUCENE_DS_CLASS = "org.neo4j.index.lucene.LuceneDataSource";
    private static final String LUCENE_FULLTEXT_DS_CLASS = "org.neo4j.index.lucene.LuceneFulltextDataSource";

    private ApplyNewLogs() {
    }

    public static void main(String[] args) {
        String destDir;
        if (args.length != 1) {
            System.err.println("Usage: ApplyNewLogs <db path>");
            System.exit(-1);
        }
        if (!new File(destDir = args[0]).exists()) {
            throw new RuntimeException("Unable to locate store in[" + destDir + "]");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("backup_slave", "true");
        EmbeddedGraphDatabase graphDb = new EmbeddedGraphDatabase(destDir);
        ApplyNewLogs.setupLuceneIfOnClasspath(destDir, graphDb);
        XaDataSourceManager xaDsMgr = graphDb.getConfig().getTxModule().getXaDataSourceManager();
        System.out.println("Starting apply of new logs...");
        for (XaDataSource xaDs : xaDsMgr.getAllRegisteredDataSources()) {
            xaDs.makeBackupSlave();
            System.out.println("Checking " + xaDs.getName() + " ...");
            long nextVersion = xaDs.getCurrentLogVersion();
            boolean logApplied = false;
            while (xaDs.hasLogicalLog(nextVersion)) {
                try {
                    xaDs.applyLog(xaDs.getLogicalLog(nextVersion));
                    logApplied = true;
                }
                catch (IOException e) {
                    throw new UnderlyingStorageException("Unable to recover slave to consistent state", (Throwable)e);
                }
                ++nextVersion;
            }
            if (logApplied) continue;
            System.out.println("No new logs for " + xaDs.getName());
        }
        graphDb.shutdown();
        System.out.println("Apply of new logs completed.");
    }

    private static void setupLuceneIfOnClasspath(String dstDir, EmbeddedGraphDatabase graphDb) {
        TxModule txModule = graphDb.getConfig().getTxModule();
        XaDataSourceManager xaDsMgr = txModule.getXaDataSourceManager();
        try {
            HashMap<String, String> params;
            Class<?> clazz = Class.forName(LUCENE_FULLTEXT_DS_CLASS);
            if (xaDsMgr.getXaDataSource("lucene-fulltext") == null) {
                params = new HashMap<String, String>();
                params.put("dir", dstDir + "/lucene-fulltext");
                txModule.registerDataSource("lucene-fulltext", clazz.getName(), "162373".getBytes(), params);
            }
            clazz = Class.forName(LUCENE_DS_CLASS);
            if (xaDsMgr.getXaDataSource("lucene") == null) {
                params = new HashMap();
                params.put("dir", dstDir + "/lucene");
                txModule.registerDataSource("lucene", clazz.getName(), "262374".getBytes(), params);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
    }
}

