/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.onlinebackup.ha;

import java.io.IOException;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.EmbeddedReadOnlyGraphDatabase;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.onlinebackup.ha.LogApplier;
import org.neo4j.onlinebackup.net.Callback;
import org.neo4j.onlinebackup.net.ConnectToMasterJob;
import org.neo4j.onlinebackup.net.Connection;
import org.neo4j.onlinebackup.net.Job;
import org.neo4j.onlinebackup.net.JobEater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSlave
implements Callback {
    private final EmbeddedReadOnlyGraphDatabase graphDb;
    private final XaDataSource[] xaDataSources;
    private final Connection[] masterConnections;
    private final JobEater jobEater;
    private final LogApplier logApplier;
    private final String masterIp;
    private final int masterPort;

    public AbstractSlave(String path, Map<String, String> params, String masterIp, int masterPort) {
        params.put("backup_slave", "true");
        this.graphDb = new EmbeddedReadOnlyGraphDatabase(path, params);
        XaDataSourceManager xaDsMgr = this.graphDb.getConfig().getTxModule().getXaDataSourceManager();
        XaDataSource nioneo = xaDsMgr.getXaDataSource("nioneodb");
        XaDataSource lucene = xaDsMgr.getXaDataSource("lucene");
        XaDataSource fulltext = xaDsMgr.getXaDataSource("lucene-fulltext");
        if (lucene != null && fulltext != null) {
            this.xaDataSources = new XaDataSource[3];
            this.xaDataSources[0] = nioneo;
            this.xaDataSources[1] = lucene;
            this.xaDataSources[2] = fulltext;
        } else {
            this.xaDataSources = new XaDataSource[1];
            this.xaDataSources[0] = nioneo;
        }
        for (XaDataSource xaDs : this.xaDataSources) {
            xaDs.makeBackupSlave();
        }
        this.recover();
        this.jobEater = new JobEater();
        this.logApplier = new LogApplier(this.xaDataSources);
        this.jobEater.start();
        this.logApplier.start();
        this.masterIp = masterIp;
        this.masterPort = masterPort;
        this.masterConnections = new Connection[this.xaDataSources.length];
        for (int i = 0; i < this.masterConnections.length; ++i) {
            this.masterConnections[i] = new Connection(masterIp, masterPort);
            while (!this.masterConnections[i].connected()) {
                if (!this.masterConnections[i].connectionRefused()) continue;
                System.out.println("Unable to connect to master");
                break;
            }
            if (!this.masterConnections[i].connected()) continue;
            String name = "nioneodb";
            if (i == 1) {
                name = "lucene";
            } else if (i == 2) {
                name = "lucene-fulltext";
            }
            this.jobEater.addJob(new ConnectToMasterJob(this.masterConnections[i], this, name, this.xaDataSources[i]));
        }
    }

    private void recover() {
        for (XaDataSource xaDs : this.xaDataSources) {
            long nextVersion = xaDs.getCurrentLogVersion();
            while (xaDs.hasLogicalLog(nextVersion)) {
                try {
                    xaDs.applyLog(xaDs.getLogicalLog(nextVersion));
                }
                catch (IOException e) {
                    throw new UnderlyingStorageException("Unable to recover slave to consistent state", (Throwable)e);
                }
                ++nextVersion;
            }
        }
    }

    public boolean isConnectedToMaster() {
        for (Connection masterConnection : this.masterConnections) {
            if (masterConnection.connected()) continue;
            return false;
        }
        return true;
    }

    public boolean reconnectToMaster() {
        for (int i = 0; i < this.masterConnections.length; ++i) {
            if (this.masterConnections[i].connected()) continue;
            this.masterConnections[i] = new Connection(this.masterIp, this.masterPort);
            while (!this.masterConnections[i].connected()) {
                if (!this.masterConnections[i].connectionRefused()) continue;
                return false;
            }
            if (!this.masterConnections[i].connected()) continue;
            String name = "nioneodb";
            if (i == 1) {
                name = "lucene";
            } else if (i == 2) {
                name = "lucene-fulltext";
            }
            this.jobEater.addJob(new ConnectToMasterJob(this.masterConnections[i], this, name, this.xaDataSources[i]));
        }
        return true;
    }

    public String getMasterIp() {
        return this.masterIp;
    }

    public int getMasterPort() {
        return this.masterPort;
    }

    @Override
    public void jobExecuted(Job job) {
    }

    public void shutdown() {
        this.jobEater.stopEating();
        this.logApplier.stopApplyLogs();
        this.graphDb.shutdown();
    }

    protected GraphDatabaseService getGraphDb() {
        return this.graphDb;
    }
}

