/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.onlinebackup.ha;

import java.nio.channels.ReadableByteChannel;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public class LogApplier
extends Thread {
    private volatile boolean run = true;
    private final XaDataSource[] xaDataSources;

    LogApplier(XaDataSource[] xaDataSources) {
        this.xaDataSources = xaDataSources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (this.run) {
                for (XaDataSource xaDs : this.xaDataSources) {
                    long logVersion = xaDs.getCurrentLogVersion();
                    if (xaDs.hasLogicalLog(logVersion)) {
                        ReadableByteChannel logChannel = xaDs.getLogicalLog(logVersion);
                        xaDs.applyLog(logChannel);
                        continue;
                    }
                    LogApplier logApplier = this;
                    synchronized (logApplier) {
                        try {
                            this.wait(250L);
                        }
                        catch (InterruptedException e) {
                            LogApplier.interrupted();
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to apply log: " + e);
            e.printStackTrace();
        }
        finally {
            this.run = false;
        }
    }

    public void stopApplyLogs() {
        this.run = false;
    }
}

