/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.onlinebackup.ha;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ServerSocketChannel;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.onlinebackup.net.AcceptJob;
import org.neo4j.onlinebackup.net.Callback;
import org.neo4j.onlinebackup.net.Connection;
import org.neo4j.onlinebackup.net.HandleIncommingSlaveJob;
import org.neo4j.onlinebackup.net.HandleSlaveConnection;
import org.neo4j.onlinebackup.net.Job;
import org.neo4j.onlinebackup.net.JobEater;
import org.neo4j.onlinebackup.net.SocketException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Master
implements Callback {
    private final EmbeddedGraphDatabase graphDb;
    private final XaDataSourceManager xaDsMgr;
    private final JobEater jobEater;
    private final ServerSocketChannel serverChannel;
    private final int port;
    private List<HandleSlaveConnection> slaveList = new CopyOnWriteArrayList<HandleSlaveConnection>();

    public Master(String path, Map<String, String> params, int listenPort) {
        this.graphDb = new EmbeddedGraphDatabase(path, params);
        this.xaDsMgr = this.graphDb.getConfig().getTxModule().getXaDataSourceManager();
        for (XaDataSource xaDs : this.xaDsMgr.getAllRegisteredDataSources()) {
            xaDs.keepLogicalLogs(true);
        }
        this.port = listenPort;
        try {
            this.serverChannel = ServerSocketChannel.open();
            this.serverChannel.configureBlocking(false);
            this.serverChannel.socket().bind(new InetSocketAddress(listenPort));
        }
        catch (IOException e) {
            throw new SocketException("Unable to bind at port[" + listenPort + "]", e);
        }
        this.jobEater = new JobEater();
        this.jobEater.addJob(new AcceptJob(this, this.serverChannel));
        this.jobEater.start();
    }

    public GraphDatabaseService getGraphDbService() {
        return this.graphDb;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void jobExecuted(Job job) {
        if (job instanceof AcceptJob) {
            AcceptJob acceptJob = (AcceptJob)job;
            if (acceptJob.getAcceptedChannel() != null) {
                Connection connection = new Connection(((AcceptJob)job).getAcceptedChannel());
                this.jobEater.addJob(new HandleIncommingSlaveJob(connection, this));
            }
        } else if (job instanceof HandleIncommingSlaveJob) {
            HandleSlaveConnection chainJob = (HandleSlaveConnection)job.getChainJob();
            if (chainJob != null) {
                this.slaveList.add(chainJob);
            } else {
                System.out.println("null chain job");
            }
        }
    }

    public void shutdown() {
        this.jobEater.stopEating();
        try {
            this.serverChannel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.graphDb.shutdown();
    }

    public long getIdentifier(String xaDsName) {
        XaDataSource xaDs = this.xaDsMgr.getXaDataSource(xaDsName);
        if (xaDs != null) {
            return xaDs.getRandomIdentifier();
        }
        return -1L;
    }

    public long getCreationTime(String xaDsName) {
        XaDataSource xaDs = this.xaDsMgr.getXaDataSource(xaDsName);
        if (xaDs != null) {
            return xaDs.getCreationTime();
        }
        return -1L;
    }

    public long getVersion(String xaDsName) {
        XaDataSource xaDs = this.xaDsMgr.getXaDataSource(xaDsName);
        if (xaDs != null) {
            return xaDs.getCurrentLogVersion();
        }
        return -1L;
    }

    public ReadableByteChannel getLog(String xaDsName, long version) throws IOException {
        XaDataSource xaDs = this.xaDsMgr.getXaDataSource(xaDsName);
        if (xaDs != null) {
            return xaDs.getLogicalLog(version);
        }
        return null;
    }

    public long getLogLength(String xaDsName, long version) {
        XaDataSource xaDs = this.xaDsMgr.getXaDataSource(xaDsName);
        if (xaDs != null) {
            return xaDs.getLogicalLogLength(version);
        }
        return -1L;
    }

    public boolean hasLog(String xaDsName, long version) {
        XaDataSource xaDs = this.xaDsMgr.getXaDataSource(xaDsName);
        if (xaDs != null) {
            return xaDs.hasLogicalLog(version);
        }
        return false;
    }

    public synchronized void rotateLogAndPushToSlaves() throws IOException {
        if (this.slaveList.size() == 0) {
            return;
        }
        for (XaDataSource xaDs : this.xaDsMgr.getAllRegisteredDataSources()) {
            xaDs.rotateLogicalLog();
        }
        CopyOnWriteArrayList<HandleSlaveConnection> newList = new CopyOnWriteArrayList<HandleSlaveConnection>();
        for (HandleSlaveConnection slave : this.slaveList) {
            XaDataSource xaDs = this.xaDsMgr.getXaDataSource(slave.getXaDsName());
            if (xaDs == null) continue;
            long version = xaDs.getCurrentLogVersion() - 1L;
            if (!slave.offerLogToSlave(version)) {
                System.out.println("Failed to offer log to slave: " + slave);
                continue;
            }
            newList.add(slave);
        }
        this.slaveList = newList;
    }
}

