/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.onlinebackup.impl;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public abstract class AbstractResource {
    final XaDataSource xaDs;

    AbstractResource(XaDataSource xaDataSource) {
        this.xaDs = xaDataSource;
    }

    public abstract void close();

    public void applyLog(ReadableByteChannel log) throws IOException {
        this.xaDs.applyLog(log);
    }

    public long getCreationTime() {
        return this.xaDs.getCreationTime();
    }

    public long getIdentifier() {
        return this.xaDs.getCreationTime();
    }

    public String getName() {
        return this.xaDs.getName();
    }

    public boolean hasLogicalLog(long version) {
        return this.xaDs.hasLogicalLog(version);
    }

    public ReadableByteChannel getLogicalLog(long version) throws IOException {
        return this.xaDs.getLogicalLog(version);
    }

    public long getVersion() {
        return this.xaDs.getCurrentLogVersion();
    }

    public void rotateLog() throws IOException {
        this.xaDs.rotateLogicalLog();
    }

    public void makeBackupSlave() {
        this.xaDs.makeBackupSlave();
    }
}

