/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.onlinebackup.impl;

import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.onlinebackup.impl.AbstractResource;
import org.neo4j.onlinebackup.impl.Neo4jResource;
import org.neo4j.onlinebackup.impl.XaDataSourceResource;

public class EmbeddedGraphDatabaseResource
extends AbstractResource
implements Neo4jResource {
    protected final EmbeddedGraphDatabase graphDb;
    protected final XaDataSourceManager xaDsm;

    public EmbeddedGraphDatabaseResource(EmbeddedGraphDatabase graphDb) {
        super(graphDb.getConfig().getPersistenceModule().getPersistenceManager().getPersistenceSource().getXaDataSource());
        this.graphDb = graphDb;
        this.xaDsm = graphDb.getConfig().getTxModule().getXaDataSourceManager();
    }

    public XaDataSourceResource getDataSource(String name) {
        XaDataSource ds = this.xaDsm.getXaDataSource(name);
        if (ds == null) {
            return null;
        }
        return new XaDataSourceResource(ds);
    }

    public XaDataSourceResource getDataSource() {
        XaDataSource ds = this.graphDb.getConfig().getPersistenceModule().getPersistenceManager().getPersistenceSource().getXaDataSource();
        if (ds == null) {
            return null;
        }
        return new XaDataSourceResource(ds);
    }

    public void close() {
        this.graphDb.shutdown();
    }
}

