/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.onlinebackup.impl;

import java.io.File;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.index.IndexService;
import org.neo4j.index.lucene.LuceneIndexService;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.onlinebackup.impl.EmbeddedGraphDatabaseResource;

public class LocalLuceneIndexResource
extends EmbeddedGraphDatabaseResource {
    private final IndexService lucene;

    private LocalLuceneIndexResource(EmbeddedGraphDatabase graphDb) {
        super(graphDb);
        this.lucene = new LuceneIndexService((GraphDatabaseService)graphDb);
    }

    public static LocalLuceneIndexResource getInstance(String storeDir) {
        String separator = System.getProperty("file.separator");
        String store = storeDir + separator + "neostore";
        if (!new File(store).exists()) {
            throw new RuntimeException("Unable to locate local neo4j store in[" + storeDir + "]");
        }
        return new LocalLuceneIndexResource(new EmbeddedGraphDatabase(storeDir));
    }

    public void close() {
        this.lucene.shutdown();
        this.graphDb.shutdown();
    }
}

