/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.onlinebackup.net;

import java.io.IOException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.neo4j.onlinebackup.net.Callback;
import org.neo4j.onlinebackup.net.Job;
import org.neo4j.onlinebackup.net.SocketException;

public class AcceptJob
extends Job {
    private final ServerSocketChannel serverChannel;
    private SocketChannel acceptedChannel = null;

    public AcceptJob(Callback callback, ServerSocketChannel channel) {
        super(callback);
        this.serverChannel = channel;
    }

    public SocketChannel getAcceptedChannel() {
        return this.acceptedChannel;
    }

    public boolean performJob() {
        try {
            if (this.serverChannel.isOpen()) {
                this.acceptedChannel = this.serverChannel.accept();
            } else {
                this.setNoRequeue();
            }
        }
        catch (IOException e) {
            throw new SocketException("Unable to accept incoming connection", e);
        }
        if (this.acceptedChannel != null) {
            this.executeCallback();
            this.acceptedChannel = null;
            return true;
        }
        return false;
    }
}

