/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.onlinebackup.net;

import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.onlinebackup.ha.AbstractSlave;
import org.neo4j.onlinebackup.net.Connection;
import org.neo4j.onlinebackup.net.ConnectionJob;
import org.neo4j.onlinebackup.net.HandleMasterConnection;
import org.neo4j.onlinebackup.net.JobStatus;

public class ConnectToMasterJob
extends ConnectionJob {
    private final AbstractSlave slave;
    private final String xaDsName;
    private final XaDataSource xaDs;
    private long masterVersion;
    private int retries = 0;

    public ConnectToMasterJob(Connection connection, AbstractSlave slave, String xaDsName, XaDataSource xaDs) {
        super(connection, slave);
        this.slave = slave;
        this.xaDsName = xaDsName;
        this.xaDs = xaDs;
        this.setStatus(Status.SETUP_GREETING);
    }

    private boolean setupGreeting() {
        if (this.retries > 20) {
            this.close();
        }
        if (!this.acquireWriteBuffer()) {
            ++this.retries;
            return false;
        }
        this.buffer.put((byte)1);
        this.buffer.putLong(this.xaDs.getRandomIdentifier());
        this.buffer.putLong(this.xaDs.getCreationTime());
        this.buffer.putLong(this.xaDs.getCurrentLogVersion());
        byte[] bytes = this.xaDsName.getBytes();
        this.buffer.putInt(bytes.length);
        this.buffer.put(bytes);
        this.buffer.flip();
        this.log("Setup greeting");
        this.setStatus(Status.SEND_GREETING);
        this.retries = 0;
        return true;
    }

    private boolean sendGreeting() {
        if (this.retries > 20) {
            this.close();
        }
        this.log("Send greeting");
        this.connection.write();
        if (!this.buffer.hasRemaining()) {
            this.releaseWriteBuffer();
            this.setStatus(Status.GET_RESPONSE);
            return true;
        }
        ++this.retries;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getResponse() {
        if (this.retries > 20) {
            this.close();
        }
        if (!this.acquireReadBuffer()) {
            ++this.retries;
            return false;
        }
        try {
            this.buffer.limit(9);
            int read = this.connection.read();
            this.log("Get greeting response");
            if (read == 1 || read == 9) {
                this.buffer.flip();
                byte masterGreeting = this.buffer.get();
                if (masterGreeting == 16) {
                    this.log("Problem connecting to master " + this.connection + ". Got BYE.");
                    this.close();
                    boolean bl = true;
                    return bl;
                }
                if (masterGreeting != 2) {
                    this.log("Got unkown greeting[" + masterGreeting + "] from " + this.connection);
                    this.close();
                } else if (read != 9) {
                    ++this.retries;
                    this.connection.pushBackAllReadData();
                    boolean bl = false;
                    return bl;
                }
                this.masterVersion = this.buffer.getLong();
                this.log("Got master version: " + this.masterVersion);
                if (this.masterVersion < this.xaDs.getCurrentLogVersion()) {
                    this.log("Got wrong version [" + this.masterVersion + "]");
                    this.close();
                    boolean bl = true;
                    return bl;
                }
                this.setNoRequeue();
                this.setChainJob(new HandleMasterConnection(this.connection, this.slave, this.masterVersion, this.xaDs));
                boolean bl = true;
                return bl;
            }
            ++this.retries;
            if (read > 0) {
                this.connection.pushBackAllReadData();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseReadBuffer();
        }
    }

    public boolean performJob() {
        switch ((Status)this.getStatus()) {
            case SETUP_GREETING: {
                return this.setupGreeting();
            }
            case SEND_GREETING: {
                return this.sendGreeting();
            }
            case GET_RESPONSE: {
                return this.getResponse();
            }
        }
        throw new IllegalStateException("Unkown status: " + this.getStatus());
    }

    void connectionClosed() {
        System.out.println("Connection closed " + this.connection);
    }

    public long getMasterVersion() {
        return this.masterVersion;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status implements JobStatus
    {
        SETUP_GREETING,
        SEND_GREETING,
        GET_RESPONSE;

    }
}

