/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.onlinebackup.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.onlinebackup.net.SocketException;

public class Connection {
    private final String ip;
    private final int port;
    private final SocketChannel channel;
    private boolean connectionRefused = false;
    private final ByteBuffer readBuffer = ByteBuffer.allocate(32768);
    private final ReentrantLock readLock = new ReentrantLock();
    private final ByteBuffer writeBuffer = ByteBuffer.allocate(32768);
    private final ReentrantLock writeLock = new ReentrantLock();
    private boolean pushBackActive = false;
    private byte[] pushBackData = null;
    private String currentAction;

    public Connection(String ip, int port) throws SocketException {
        this.ip = ip;
        this.port = port;
        InetSocketAddress remoteHost = new InetSocketAddress(ip, port);
        try {
            this.channel = SocketChannel.open();
            this.channel.configureBlocking(false);
            this.channel.connect(remoteHost);
        }
        catch (IOException e) {
            this.connectionRefused = true;
            throw new SocketException("Could not connect to host[" + ip + ":" + port + "]", e);
        }
    }

    public Connection(SocketChannel channel) {
        if (channel == null) {
            throw new IllegalArgumentException("Null channel");
        }
        this.channel = channel;
        this.port = channel.socket().getPort();
        this.ip = channel.socket().getInetAddress().getHostAddress();
        this.setNonBlocking();
    }

    private void setNonBlocking() {
        try {
            this.channel.configureBlocking(false);
        }
        catch (IOException e) {
            throw new SocketException("Unable to configure non blocking", e);
        }
    }

    public String getAction() {
        return this.currentAction;
    }

    public void setCurrentAction(String action) {
        this.currentAction = action;
    }

    public boolean connected() {
        if (!this.channel.isBlocking() && !this.channel.isConnected() && this.channel.isConnectionPending()) {
            try {
                return this.channel.finishConnect();
            }
            catch (IOException e) {
                this.connectionRefused = true;
            }
        }
        return this.channel.isConnected();
    }

    public void close() throws SocketException {
        this.readLock.lock();
        this.readBuffer.clear();
        this.writeLock.lock();
        this.writeBuffer.clear();
        try {
            this.channel.close();
        }
        catch (IOException e) {
            throw new SocketException("Error closing channel to [" + this.ip + ":" + this.port + "]", e);
        }
        this.readLock.unlock();
        this.writeLock.unlock();
    }

    public boolean connectionRefused() {
        return this.connectionRefused;
    }

    public String toString() {
        return "Connection[" + this.ip + ":" + this.port + "]";
    }

    public ByteBuffer tryAcquireReadBuffer() {
        if (this.readLock.tryLock()) {
            this.readBuffer.clear();
            return this.readBuffer;
        }
        return null;
    }

    public void releaseReadBuffer() {
        this.readLock.unlock();
    }

    public ByteBuffer tryAcquireWriteBuffer() {
        if (this.writeLock.tryLock()) {
            this.writeBuffer.clear();
            return this.writeBuffer;
        }
        return null;
    }

    public void releaseWriteBuffer() {
        this.writeLock.unlock();
    }

    public int read() {
        try {
            if (this.pushBackActive) {
                if (this.readBuffer.limit() < this.pushBackData.length) {
                    this.readBuffer.put(this.pushBackData, 0, this.readBuffer.limit());
                    int length = this.pushBackData.length - this.readBuffer.limit();
                    byte[] restData = new byte[length];
                    System.arraycopy(this.pushBackData, this.readBuffer.limit(), restData, 0, length);
                    this.pushBackData = restData;
                    return this.readBuffer.position();
                }
                this.pushBackActive = false;
                this.readBuffer.put(this.pushBackData);
                this.pushBackData = null;
            }
            this.channel.read(this.readBuffer);
            return this.readBuffer.position();
        }
        catch (IOException e) {
            throw new SocketException(this.toString() + " error reading", e);
        }
    }

    public void pushBackReadData(byte[] data) {
        if (data.length > 0) {
            this.pushBackActive = true;
            this.pushBackData = data;
        }
    }

    public void pushBackAllReadData() {
        this.readBuffer.flip();
        if (this.readBuffer.limit() > 0) {
            this.pushBackActive = true;
            this.pushBackData = new byte[this.readBuffer.limit()];
            this.readBuffer.get(this.pushBackData);
        }
    }

    public int write() {
        try {
            return this.channel.write(this.writeBuffer);
        }
        catch (IOException e) {
            this.close();
            throw new SocketException(this.toString() + " error writing", e);
        }
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getHostAsString() {
        return this.ip + ":" + this.port;
    }
}

