/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.onlinebackup.net;

import java.nio.ByteBuffer;
import org.neo4j.onlinebackup.net.Callback;
import org.neo4j.onlinebackup.net.Connection;
import org.neo4j.onlinebackup.net.Job;
import org.neo4j.onlinebackup.net.JobStatus;

public abstract class ConnectionJob
extends Job {
    protected final Connection connection;
    protected ByteBuffer buffer;

    public ConnectionJob(Connection connection, Callback callback) {
        super(callback);
        this.connection = connection;
    }

    public ConnectionJob(String ip, int port, Callback callback) {
        super(callback);
        this.connection = new Connection(ip, port);
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected void setStatus(JobStatus newStatus) {
        super.setStatus(newStatus);
        this.connection.setCurrentAction(newStatus.name());
    }

    protected boolean acquireReadBuffer() {
        if (this.buffer != null) {
            throw new IllegalStateException("buffer not null");
        }
        this.buffer = this.connection.tryAcquireReadBuffer();
        return this.buffer != null;
    }

    protected void releaseReadBuffer() {
        this.buffer = null;
        this.connection.releaseReadBuffer();
    }

    protected boolean acquireWriteBuffer() {
        if (this.buffer != null) {
            throw new IllegalStateException("buffer not null");
        }
        this.buffer = this.connection.tryAcquireWriteBuffer();
        return this.buffer != null;
    }

    protected void releaseWriteBuffer() {
        this.buffer = null;
        this.connection.releaseWriteBuffer();
    }

    protected void close() {
        this.setNoRequeue();
        this.connection.close();
        this.connectionClosed();
    }

    abstract void connectionClosed();
}

