/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.onlinebackup.net;

import org.neo4j.onlinebackup.ha.Master;
import org.neo4j.onlinebackup.net.Connection;
import org.neo4j.onlinebackup.net.ConnectionJob;
import org.neo4j.onlinebackup.net.HandleSlaveConnection;
import org.neo4j.onlinebackup.net.JobStatus;

public class HandleIncommingSlaveJob
extends ConnectionJob {
    private final Master master;
    private long slaveVersion;
    private String xaDsName;
    private int retries = 0;

    public HandleIncommingSlaveJob(Connection connection, Master master) {
        super(connection, master);
        this.master = master;
        this.setStatus(Status.GET_GREETING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getGreeting() {
        if (this.retries > 20) {
            this.close();
        }
        if (!this.acquireReadBuffer()) {
            return false;
        }
        try {
            int read = this.connection.read();
            if (read > 29) {
                this.buffer.flip();
                byte slaveGreeting = this.buffer.get();
                if (slaveGreeting != 1) {
                    this.setStatus(Status.SEND_BYE);
                    boolean bl = true;
                    return bl;
                }
                long id = this.buffer.getLong();
                long timestamp = this.buffer.getLong();
                long version = this.buffer.getLong();
                int strLen = this.buffer.getInt();
                byte[] bytes = new byte[strLen];
                this.buffer.get(bytes);
                this.xaDsName = new String(bytes);
                long masterId = this.master.getIdentifier(this.xaDsName);
                long masterTimestamp = this.master.getCreationTime(this.xaDsName);
                long masterVersion = this.master.getVersion(this.xaDsName);
                if (id != masterId || timestamp != masterTimestamp || version > masterVersion) {
                    this.log("Got wrong id/time/version [" + id + "/" + timestamp + "/" + version + "]" + "[" + masterId + "/" + masterTimestamp + "/" + masterVersion + "] for data source " + this.xaDsName);
                    this.setStatus(Status.SEND_BYE);
                    boolean bl = true;
                    return bl;
                }
                this.log("Got slave version[" + version + "]. I am version[" + this.master.getVersion(this.xaDsName) + "] for data source " + this.xaDsName);
                this.slaveVersion = version;
                this.setStatus(Status.SETUP_GREETING);
                this.retries = 0;
                boolean bl = true;
                return bl;
            }
            ++this.retries;
            if (read > 0) {
                this.connection.pushBackAllReadData();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseReadBuffer();
        }
    }

    private boolean setupGreeting() {
        if (this.retries > 20) {
            this.close();
        }
        if (!this.acquireWriteBuffer()) {
            ++this.retries;
            return false;
        }
        this.buffer.put((byte)2);
        this.buffer.putLong(this.master.getVersion(this.xaDsName));
        this.buffer.flip();
        this.log("Setup greeting");
        this.setStatus(Status.SEND_GREETING);
        this.retries = 0;
        return true;
    }

    private boolean sendGreeting() {
        if (this.retries > 20) {
            this.close();
        }
        this.log("Send greeting");
        this.connection.write();
        if (!this.buffer.hasRemaining()) {
            this.releaseWriteBuffer();
            this.setNoRequeue();
            this.setChainJob(new HandleSlaveConnection(this.connection, this.master, this.xaDsName));
            return true;
        }
        ++this.retries;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendBye() {
        if (this.retries > 20) {
            this.close();
        }
        if (!this.acquireWriteBuffer()) {
            ++this.retries;
            return false;
        }
        try {
            this.log("Send bye");
            this.buffer.put((byte)16);
            this.buffer.flip();
            this.connection.write();
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseWriteBuffer();
            this.close();
        }
    }

    public boolean performJob() {
        switch ((Status)this.getStatus()) {
            case GET_GREETING: {
                return this.getGreeting();
            }
            case SETUP_GREETING: {
                return this.setupGreeting();
            }
            case SEND_GREETING: {
                return this.sendGreeting();
            }
            case SEND_BYE: {
                return this.sendBye();
            }
        }
        throw new IllegalStateException("Unkown status: " + this.getStatus());
    }

    void connectionClosed() {
        System.out.println("Connection closed " + this.connection);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status implements JobStatus
    {
        GET_GREETING,
        SETUP_GREETING,
        SEND_GREETING,
        SEND_BYE;

    }
}

