/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.onlinebackup.net;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Random;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.onlinebackup.ha.AbstractSlave;
import org.neo4j.onlinebackup.net.Connection;
import org.neo4j.onlinebackup.net.ConnectionJob;
import org.neo4j.onlinebackup.net.JobStatus;
import org.neo4j.onlinebackup.net.SocketException;

public class HandleMasterConnection
extends ConnectionJob {
    private static final Random r = new Random(System.currentTimeMillis());
    private final XaDataSource xaDs;
    private int retries = 0;
    private File tempFile;
    private FileChannel logToWrite = null;
    private long logLength = -1L;
    private long logVersionWriting = -1L;
    private long masterVersion = -1L;

    public HandleMasterConnection(Connection connection, AbstractSlave slave, long masterVersion, XaDataSource xaDs) {
        super(connection, slave);
        this.xaDs = xaDs;
        this.masterVersion = masterVersion;
        if (xaDs.getCurrentLogVersion() < masterVersion - 1L) {
            this.setStatus(Status.SETUP_REQUEST);
        } else {
            this.setStatus(Status.GET_MESSAGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getMessage() {
        if (!this.acquireReadBuffer()) {
            return false;
        }
        try {
            this.buffer.limit(17);
            int read = this.connection.read();
            if (read == 17) {
                this.buffer.flip();
                byte request = this.buffer.get();
                if (request != 6) {
                    this.log("Unkown request: " + request);
                    this.close();
                    boolean bl = true;
                    return bl;
                }
                long version = this.buffer.getLong();
                if (version < this.xaDs.getCurrentLogVersion()) {
                    this.log("Got wrong version [" + version + "]");
                    this.setStatus(Status.SETUP_NOT_OK);
                    boolean bl = true;
                    return bl;
                }
                if (version > this.masterVersion) {
                    this.masterVersion = version;
                }
                this.logLength = this.buffer.getLong();
                this.log("Got offer: " + version + "," + this.logLength);
                if (!this.xaDs.hasLogicalLog(version)) {
                    try {
                        this.logVersionWriting = version;
                        do {
                            this.tempFile = new File(this.xaDs.getName() + "-logical-transfer.v" + Long.toString(version) + "_" + r.nextLong());
                        } while (this.tempFile.exists());
                        this.logToWrite = new RandomAccessFile(this.tempFile, "rw").getChannel();
                        this.logToWrite.truncate(0L);
                    }
                    catch (IOException e) {
                        this.close();
                        throw new SocketException("Unable to setup logical log[" + version + "] for writing", e);
                    }
                    this.setStatus(Status.SETUP_OK);
                } else {
                    this.log("We already have log version[" + version + "]");
                    this.setStatus(Status.SETUP_NOT_OK);
                }
                this.retries = 0;
                boolean bl = true;
                return bl;
            }
            if (read > 0) {
                this.connection.pushBackAllReadData();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseReadBuffer();
        }
    }

    private boolean setupRequest() {
        long version;
        for (version = this.xaDs.getCurrentLogVersion(); version < this.masterVersion && this.xaDs.hasLogicalLog(version); ++version) {
        }
        if (version == this.masterVersion) {
            this.setStatus(Status.GET_MESSAGE);
            return true;
        }
        if (this.retries > 20) {
            this.close();
        }
        if (!this.acquireWriteBuffer()) {
            ++this.retries;
            return false;
        }
        this.buffer.put((byte)5);
        this.buffer.putLong(version);
        this.buffer.flip();
        this.log("Setup request: " + version);
        this.setStatus(Status.SEND_REQUEST);
        this.retries = 0;
        return true;
    }

    private boolean sendRequest() {
        if (this.retries > 20) {
            this.close();
        }
        this.log("Send request");
        this.connection.write();
        if (!this.buffer.hasRemaining()) {
            this.buffer.clear();
            this.releaseWriteBuffer();
            this.setStatus(Status.GET_MESSAGE);
            return true;
        }
        ++this.retries;
        return false;
    }

    private boolean setupNotOk() {
        if (this.retries > 20) {
            this.close();
        }
        if (!this.acquireWriteBuffer()) {
            ++this.retries;
            return false;
        }
        this.buffer.put((byte)9);
        this.buffer.flip();
        this.log("Setup not ok");
        this.setStatus(Status.SEND_NOT_OK);
        this.retries = 0;
        return true;
    }

    private boolean sendNotOk() {
        if (this.retries > 20) {
            this.close();
        }
        this.log("Send not ok");
        this.connection.write();
        if (!this.buffer.hasRemaining()) {
            this.buffer.clear();
            this.releaseWriteBuffer();
            this.setStatus(Status.GET_MESSAGE);
            return true;
        }
        ++this.retries;
        return false;
    }

    private boolean setupOk() {
        if (this.retries > 20) {
            this.close();
        }
        if (!this.acquireWriteBuffer()) {
            ++this.retries;
            return false;
        }
        this.buffer.put((byte)7);
        this.buffer.flip();
        this.log("Setup ok");
        this.setStatus(Status.SEND_OK);
        this.retries = 0;
        return true;
    }

    private boolean sendOk() {
        if (this.retries > 20) {
            this.close();
        }
        this.log("Send ok");
        this.connection.write();
        if (!this.buffer.hasRemaining()) {
            this.buffer.clear();
            this.releaseWriteBuffer();
            this.setStatus(Status.GET_LOG);
            return true;
        }
        ++this.retries;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getLog() {
        if (!this.acquireReadBuffer()) {
            return false;
        }
        this.log("Get log");
        try {
            int read = this.connection.read();
            if (read > 0) {
                this.buffer.flip();
                if (this.logToWrite.position() + (long)read <= this.logLength) {
                    this.logToWrite.write(this.buffer);
                } else {
                    int readLimit = this.buffer.limit();
                    int logLimit = (int)(this.logLength - this.logToWrite.position());
                    this.buffer.limit(logLimit);
                    this.logToWrite.write(this.buffer);
                    this.buffer.limit(readLimit);
                    byte[] pushData = new byte[readLimit - logLimit];
                    this.buffer.get(pushData);
                    this.connection.pushBackReadData(pushData);
                }
                if (this.logToWrite.position() >= this.logLength) {
                    this.log("Log transfer complete");
                    if (this.xaDs.getCurrentLogVersion() < this.masterVersion - 1L) {
                        this.setStatus(Status.SETUP_REQUEST);
                    } else {
                        this.setStatus(Status.GET_MESSAGE);
                    }
                    this.logToWrite.close();
                    String newName = this.xaDs.getFileName(this.logVersionWriting);
                    File newLog = new File(newName);
                    if (newLog.exists()) {
                        this.log("Error new log file[" + newName + "] already exist");
                        this.close();
                    }
                    if (!this.tempFile.renameTo(new File(newName))) {
                        this.log("Unable to move log to " + newName);
                        this.close();
                    }
                    this.logVersionWriting = -1L;
                    this.tempFile = null;
                    this.logToWrite = null;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            this.close();
            this.log("Error getting log.", e);
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseReadBuffer();
        }
    }

    public boolean performJob() {
        switch ((Status)this.getStatus()) {
            case GET_LOG: {
                return this.getLog();
            }
            case GET_MESSAGE: {
                return this.getMessage();
            }
            case SETUP_REQUEST: {
                return this.setupRequest();
            }
            case SEND_REQUEST: {
                return this.sendRequest();
            }
            case SETUP_OK: {
                return this.setupOk();
            }
            case SEND_OK: {
                return this.sendOk();
            }
            case SETUP_NOT_OK: {
                return this.setupNotOk();
            }
            case SEND_NOT_OK: {
                return this.sendNotOk();
            }
        }
        throw new IllegalStateException("Unkown status: " + this.getStatus());
    }

    void connectionClosed() {
        System.out.println("Connection closed " + this.connection);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status implements JobStatus
    {
        GET_LOG,
        GET_MESSAGE,
        SETUP_NOT_OK,
        SEND_NOT_OK,
        SETUP_OK,
        SEND_OK,
        SETUP_REQUEST,
        SEND_REQUEST;

    }
}

