/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.onlinebackup.net;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.onlinebackup.ha.Master;
import org.neo4j.onlinebackup.net.Connection;
import org.neo4j.onlinebackup.net.ConnectionJob;
import org.neo4j.onlinebackup.net.JobStatus;
import org.neo4j.onlinebackup.net.SocketException;

public class HandleSlaveConnection
extends ConnectionJob {
    private final Master master;
    private final String xaDsName;
    private int retries = 0;
    private long logVersionToSend = -1L;
    private ReadableByteChannel logToSend = null;
    private long logLength = -1L;
    private long nextLogVersion = -1L;

    public HandleSlaveConnection(Connection connection, Master master, String xaDsName) {
        super(connection, master);
        this.master = master;
        this.xaDsName = xaDsName;
        this.setStatus(Status.GET_MESSAGE);
    }

    public String getXaDsName() {
        return this.xaDsName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean getMessage() {
        if (!this.acquireReadBuffer()) {
            return false;
        }
        try {
            this.buffer.limit(9);
            int read = this.connection.read();
            if (read == 9) {
                this.buffer.flip();
                byte request = this.buffer.get();
                if (request != 5) {
                    this.log("Unkown request: " + request);
                    this.close();
                    boolean bl = true;
                    return bl;
                }
                this.logVersionToSend = this.buffer.getLong();
                if (this.logVersionToSend > this.master.getVersion(this.xaDsName)) {
                    this.log("Got wrong version [" + this.logVersionToSend + "]");
                    boolean bl = true;
                    return bl;
                }
                this.log("Slave request: " + this.logVersionToSend);
                if (this.master.hasLog(this.xaDsName, this.logVersionToSend)) {
                    try {
                        this.logToSend = this.master.getLog(this.xaDsName, this.logVersionToSend);
                        this.logLength = this.master.getLogLength(this.xaDsName, this.logVersionToSend);
                    }
                    catch (IOException e) {
                        this.close();
                        throw new SocketException("Unable to get logical log[" + this.logVersionToSend + "]", e);
                    }
                } else {
                    this.log("No such log version[" + this.logVersionToSend + "]");
                    boolean bl = true;
                    return bl;
                }
                this.setStatus(Status.SETUP_OFFER_LOG);
                this.retries = 0;
                boolean bl = true;
                return bl;
            }
            if (read > 0) {
                this.connection.pushBackAllReadData();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseReadBuffer();
        }
    }

    private boolean setupOfferLog() {
        if (this.retries > 20) {
            this.close();
        }
        if (!this.acquireWriteBuffer()) {
            ++this.retries;
            return false;
        }
        this.log("Setup offer: " + this.logVersionToSend + "," + this.logLength);
        this.buffer.put((byte)6);
        this.buffer.putLong(this.logVersionToSend);
        this.buffer.putLong(this.logLength);
        this.buffer.flip();
        this.setStatus(Status.SEND_OFFER);
        this.retries = 0;
        return true;
    }

    private boolean sendOffer() {
        if (this.retries > 20) {
            this.close();
        }
        this.log("Send offer: " + this.logVersionToSend + "," + this.logLength);
        this.connection.write();
        if (!this.buffer.hasRemaining()) {
            this.releaseWriteBuffer();
            this.setStatus(Status.GET_OK);
            return true;
        }
        ++this.retries;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getOk() {
        if (!this.acquireReadBuffer()) {
            return false;
        }
        try {
            this.buffer.limit(1);
            int read = this.connection.read();
            if (read == 1) {
                this.buffer.flip();
                byte status = this.buffer.get();
                if (status == 7) {
                    this.setStatus(Status.SETUP_SEND_LOG);
                } else if (status == 9) {
                    this.setStatus(Status.GET_MESSAGE);
                    this.logVersionToSend = -1L;
                    this.logLength = -1L;
                    this.logToSend = null;
                } else {
                    this.log("Unkown ok message: " + status);
                    this.close();
                }
                this.log("Get ok: " + status);
                this.retries = 0;
                boolean bl = true;
                return bl;
            }
            ++this.retries;
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseReadBuffer();
        }
    }

    private boolean setupSendLog() {
        if (this.retries > 20) {
            this.close();
        }
        if (!this.acquireWriteBuffer()) {
            ++this.retries;
            return false;
        }
        this.log("Setup log: " + this.logVersionToSend);
        try {
            this.logToSend.read(this.buffer);
        }
        catch (IOException e) {
            this.log("Error reading log", e);
            this.close();
            return true;
        }
        this.buffer.flip();
        this.setStatus(Status.SEND_LOG);
        this.retries = 0;
        return true;
    }

    private boolean sendLog() {
        if (this.retries > 20) {
            this.close();
        }
        this.connection.write();
        this.log("Send log: " + this.logVersionToSend);
        if (!this.buffer.hasRemaining()) {
            this.buffer.clear();
            try {
                if (this.logToSend.read(this.buffer) <= 0) {
                    this.releaseWriteBuffer();
                    this.logToSend.close();
                    if (this.nextLogVersion != -1L) {
                        this.logToSend = this.master.getLog(this.xaDsName, this.nextLogVersion);
                        this.logLength = this.master.getLogLength(this.xaDsName, this.nextLogVersion);
                        this.logVersionToSend = this.nextLogVersion;
                        this.nextLogVersion = -1L;
                        this.setStatus(Status.SETUP_OFFER_LOG);
                    } else {
                        this.setStatus(Status.GET_MESSAGE);
                    }
                    this.logLength = -1L;
                    this.logVersionToSend = -1L;
                    this.logToSend = null;
                    return true;
                }
                this.buffer.flip();
            }
            catch (IOException e) {
                this.log("Error reading log", e);
                this.close();
                return true;
            }
        }
        ++this.retries;
        return false;
    }

    public boolean performJob() {
        switch ((Status)this.getStatus()) {
            case GET_MESSAGE: {
                return this.getMessage();
            }
            case SETUP_OFFER_LOG: {
                return this.setupOfferLog();
            }
            case SEND_OFFER: {
                return this.sendOffer();
            }
            case GET_OK: {
                return this.getOk();
            }
            case SETUP_SEND_LOG: {
                return this.setupSendLog();
            }
            case SEND_LOG: {
                return this.sendLog();
            }
        }
        throw new IllegalStateException("Unkown status: " + this.getStatus());
    }

    public synchronized boolean offerLogToSlave(long version) {
        if (!this.getConnection().connected()) {
            System.out.println("Not connected");
            return false;
        }
        if (this.logLength != -1L || this.logVersionToSend != -1L || this.logToSend != null) {
            return true;
        }
        try {
            if (this.getStatus() == Status.GET_MESSAGE) {
                this.logToSend = this.master.getLog(this.xaDsName, version);
                this.logLength = this.master.getLogLength(this.xaDsName, version);
                this.logVersionToSend = version;
                this.setStatus(Status.SETUP_OFFER_LOG);
            }
            return true;
        }
        catch (IOException e) {
            throw new SocketException("Unable to get logical log[" + this.logVersionToSend + "]", e);
        }
    }

    void connectionClosed() {
        System.out.println("Connection closed " + this.connection);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status implements JobStatus
    {
        GET_MESSAGE,
        SETUP_OFFER_LOG,
        SEND_OFFER,
        GET_OK,
        SETUP_SEND_LOG,
        SEND_LOG;

    }
}

