/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.onlinebackup.net;

import org.neo4j.onlinebackup.net.Callback;
import org.neo4j.onlinebackup.net.JobStatus;

public abstract class Job {
    private boolean reQueue = true;
    private Callback callback = null;
    private Job chainJob = null;
    private JobStatus status = Status.NO_STATUS;

    protected Job() {
    }

    protected Job(Callback callback) {
        this.callback = callback;
    }

    protected void setRequeue() {
        this.reQueue = true;
    }

    protected void setNoRequeue() {
        this.reQueue = false;
    }

    public boolean needsRequeue() {
        return this.reQueue;
    }

    public abstract boolean performJob();

    public void executeCallback() {
        if (this.callback != null) {
            this.callback.jobExecuted(this);
        }
    }

    public void setChainJob(Job job) {
        this.chainJob = job;
    }

    public Job getChainJob() {
        return this.chainJob;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    protected void setStatus(JobStatus status) {
        this.status = status;
    }

    protected void log(String message) {
    }

    protected void log(String message, Throwable cause) {
        System.out.println(this + ": " + message);
        cause.printStackTrace();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status implements JobStatus
    {
        NO_STATUS;

    }
}

