/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.onlinebackup.net;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.neo4j.onlinebackup.net.ConnectionJob;
import org.neo4j.onlinebackup.net.Job;

public class JobEater
extends Thread {
    private final Queue<Job> queue = new ConcurrentLinkedQueue<Job>();
    private List<Job> slowList = new LinkedList<Job>();
    private volatile boolean run = true;

    public boolean addJob(Job job) {
        return this.queue.offer(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int count = 0;
        while (this.run) {
            Job job = this.queue.poll();
            if (job != null && count < 200) {
                ++count;
                try {
                    boolean progressing = job.performJob();
                    if (job.needsRequeue()) {
                        if (progressing) {
                            boolean success = this.queue.offer(job);
                            assert (success);
                            continue;
                        }
                        this.slowList.add(job);
                        continue;
                    }
                    job.executeCallback();
                    Job chainJob = job.getChainJob();
                    if (chainJob == null) continue;
                    boolean success = this.queue.offer(chainJob);
                    assert (success);
                    continue;
                }
                catch (Throwable t) {
                    System.out.println("Throwing away " + job);
                    t.printStackTrace();
                    try {
                        job.setNoRequeue();
                        job.executeCallback();
                    }
                    catch (Throwable tt) {
                        tt.printStackTrace();
                    }
                    if (!(job instanceof ConnectionJob)) continue;
                    ((ConnectionJob)job).close();
                    continue;
                }
            }
            if (count < 200) {
                JobEater t = this;
                synchronized (t) {
                    try {
                        this.wait(250L);
                    }
                    catch (InterruptedException e) {
                        JobEater.interrupted();
                    }
                }
            }
            count = 0;
            LinkedList<Job> newSlowList = new LinkedList<Job>();
            for (Job slowJob : this.slowList) {
                try {
                    boolean progressing = slowJob.performJob();
                    if (slowJob.needsRequeue()) {
                        if (progressing) {
                            boolean success = this.queue.offer(slowJob);
                            assert (success);
                            continue;
                        }
                        newSlowList.add(slowJob);
                        continue;
                    }
                    slowJob.executeCallback();
                    Job chainJob = slowJob.getChainJob();
                    if (chainJob == null) continue;
                    boolean success = this.queue.offer(chainJob);
                    assert (success);
                }
                catch (Throwable t) {
                    System.out.println("Throwing away " + slowJob);
                    t.printStackTrace();
                    try {
                        slowJob.setNoRequeue();
                        slowJob.executeCallback();
                    }
                    catch (Throwable tt) {
                        tt.printStackTrace();
                    }
                    if (!(job instanceof ConnectionJob)) continue;
                    ((ConnectionJob)job).close();
                }
            }
            this.slowList = newSlowList;
        }
    }

    public void stopEating() {
        this.run = false;
    }
}

