/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongPeekingIterator;

public class PrimitiveLongPeekingIteratorTest {
    @Test
    public void shouldDetectMultipleValues() {
        long[] values = new long[]{1L, 2L, 3L};
        PrimitiveLongIterator actual = PrimitiveLongCollections.iterator((long[])values);
        PrimitiveLongPeekingIterator peekingIterator = new PrimitiveLongPeekingIterator(actual);
        Assert.assertTrue((boolean)peekingIterator.hasMultipleValues());
        for (long value : values) {
            Assert.assertEquals((long)value, (long)peekingIterator.next());
        }
        Assert.assertFalse((boolean)peekingIterator.hasNext());
        Assert.assertTrue((boolean)peekingIterator.hasMultipleValues());
    }

    @Test
    public void shouldDetectSingleValue() {
        long[] values = new long[]{1L};
        PrimitiveLongIterator actual = PrimitiveLongCollections.iterator((long[])values);
        PrimitiveLongPeekingIterator peekingIterator = new PrimitiveLongPeekingIterator(actual);
        Assert.assertFalse((boolean)peekingIterator.hasMultipleValues());
        for (long value : values) {
            Assert.assertEquals((long)value, (long)peekingIterator.next());
        }
        Assert.assertFalse((boolean)peekingIterator.hasNext());
        Assert.assertFalse((boolean)peekingIterator.hasMultipleValues());
    }
}

