/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongIntMap;
import org.neo4j.test.randomized.Action;
import org.neo4j.test.randomized.LinePrinter;
import org.neo4j.test.randomized.Printable;
import org.neo4j.test.randomized.RandomizedTester;
import org.neo4j.test.randomized.Result;
import org.neo4j.test.randomized.TestResource;

public class PrimitiveLongIntMapRIT {
    @Test
    public void thoroughlyTestIt() throws Exception {
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(5L);
        while (System.currentTimeMillis() < endTime) {
            long seed = System.currentTimeMillis();
            Random random = new Random(seed);
            int max = random.nextInt(10000) + 100;
            RandomizedTester<Maps, String> actions = new RandomizedTester<Maps, String>(this.mapFactory(), this.actionFactory(random));
            Result<Maps, String> result = actions.run(max);
            if (result.isFailure()) {
                System.out.println("Found failure at " + result);
                actions.testCaseWriter("shouldOnlyContainAddedValues", this.given()).print(System.out);
                System.out.println("Actually, minimal reproducible test of that is...");
                actions.findMinimalReproducible().testCaseWriter("shouldOnlyContainAddedValues", this.given()).print(System.out);
                Assert.fail((String)("Failed, see printed test case for how to reproduce. Seed:" + seed));
            }
            this.fullVerification(result.getTarget(), random);
        }
    }

    private void fullVerification(Maps target, Random random) {
        for (Map.Entry<Long, Integer> entry : target.normalMap.entrySet()) {
            Assert.assertTrue((boolean)target.map.containsKey(entry.getKey().longValue()));
            Assert.assertEquals((long)entry.getValue().intValue(), (long)target.map.get(entry.getKey().longValue()));
        }
        for (int i = 0; i < target.normalMap.size(); ++i) {
            Assert.assertFalse((boolean)target.map.containsKey(this.randomNonExisting(random, target.normalMap)));
        }
    }

    private Printable given() {
        return new Printable(){

            @Override
            public void print(LinePrinter out) {
                out.println(PrimitiveLongIntMap.class.getSimpleName() + " map = " + Primitive.class.getSimpleName() + ".longIntMap();");
            }
        };
    }

    private RandomizedTester.ActionFactory<Maps, String> actionFactory(final Random random) {
        return new RandomizedTester.ActionFactory<Maps, String>(){

            @Override
            public Action<Maps, String> apply(Maps from) {
                return PrimitiveLongIntMapRIT.this.generateAction(random, from);
            }
        };
    }

    private RandomizedTester.TargetFactory<Maps> mapFactory() {
        return new RandomizedTester.TargetFactory<Maps>(){

            @Override
            public Maps newInstance() {
                return new Maps();
            }
        };
    }

    protected Action<Maps, String> generateAction(Random random, Maps from) {
        boolean anExisting = !from.normalMap.isEmpty() && random.nextInt(3) == 0;
        long key = anExisting ? this.randomExisting(random, from.normalMap) : this.randomNonExisting(random, from.normalMap);
        Integer value = random.nextInt(100);
        int typeOfAction = random.nextInt(5);
        if (typeOfAction == 0) {
            return new RemoveAction(key);
        }
        return new AddAction(key, value);
    }

    private long randomNonExisting(Random random, Map<Long, Integer> existing) {
        long key;
        while (existing.containsKey(key = Math.abs(random.nextLong()))) {
        }
        return key;
    }

    private long randomExisting(Random random, Map<Long, Integer> existing) {
        int index = random.nextInt(existing.size()) + 1;
        Iterator<Long> iterator = existing.keySet().iterator();
        long value = 0L;
        for (int i = 0; i < index; ++i) {
            value = iterator.next();
        }
        return value;
    }

    private static String capitilize(boolean bool) {
        String string = Boolean.valueOf(bool).toString();
        return string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
    }

    private static class Maps
    implements TestResource {
        final Map<Long, Integer> normalMap = new HashMap<Long, Integer>();
        final PrimitiveLongIntMap map = Primitive.longIntMap();

        private Maps() {
        }

        public String toString() {
            return this.map.toString();
        }

        @Override
        public void close() {
        }
    }

    private static class RemoveAction
    implements Action<Maps, String> {
        private final long key;

        RemoveAction(long key) {
            this.key = key;
        }

        @Override
        public String apply(Maps target) {
            boolean existing = target.normalMap.containsKey(this.key);
            int existingValue = existing ? target.normalMap.get(this.key) : -1;
            boolean existedBefore = target.map.containsKey(this.key);
            int valueBefore = target.map.get(this.key);
            int removed = target.map.remove(this.key);
            boolean existsAfter = target.map.containsKey(this.key);
            int valueAfter = target.map.get(this.key);
            target.normalMap.remove(this.key);
            boolean ok = existedBefore == existing & existingValue == valueBefore & existingValue == removed & valueAfter == -1 & !existsAfter;
            return ok ? null : "" + this.key + "," + existingValue + "," + existedBefore + "," + removed + "," + existsAfter;
        }

        @Override
        public void printAsCode(Maps source, LinePrinter out, boolean includeChecks) {
            String removal = "map.remove( " + this.key + " );";
            if (includeChecks) {
                boolean existing = source.normalMap.containsKey(this.key);
                int existingValue = existing ? source.normalMap.get(this.key) : -1;
                out.println(String.format("boolean existedBefore = map.containsKey( %d );", this.key));
                out.println(String.format("int valueBefore = map.get( %d );", this.key));
                out.println(String.format("int removed = %s", removal));
                out.println(String.format("boolean existsAfter = map.containsKey( %d );", this.key));
                out.println(String.format("int valueAfter = map.get( %d );", this.key));
                out.println(String.format("assert%s( \"%s\", existedBefore );", PrimitiveLongIntMapRIT.capitilize(existing), this.key + " should " + (existing ? "" : "not ") + "exist before removing here"));
                out.println(String.format("assertEquals( \"%s\", %d, valueBefore );", "value before should be " + existingValue, existingValue));
                out.println(String.format("assertEquals( \"%s\", %d, removed );", "value returned from remove should be " + existingValue, existingValue));
                out.println(String.format("assertFalse( \"%s\", existsAfter );", this.key + " should not exist"));
                out.println(String.format("assertEquals( \"%s\", -1, valueAfter );", "value after removing should be -1"));
            } else {
                out.println(removal);
            }
        }
    }

    private static class AddAction
    implements Action<Maps, String> {
        private final long key;
        private final int value;

        AddAction(long key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String apply(Maps target) {
            boolean existing = target.normalMap.containsKey(this.key);
            int existingValue = existing ? target.normalMap.get(this.key) : -1;
            int actualSizeBefore = target.normalMap.size();
            int sizeBefore = target.map.size();
            boolean existedBefore = target.map.containsKey(this.key);
            int valueBefore = target.map.get(this.key);
            int previous = target.map.put(this.key, this.value);
            boolean existsAfter = target.map.containsKey(this.key);
            int valueAfter = target.map.get(this.key);
            target.normalMap.put(this.key, this.value);
            int sizeAfter = target.map.size();
            int actualSizeAfter = target.normalMap.size();
            boolean ok = sizeBefore == actualSizeBefore & existedBefore == existing & existingValue == valueBefore & existingValue == previous & valueAfter == this.value & existsAfter & sizeAfter == actualSizeAfter;
            return ok ? null : "" + this.key + ":" + this.value + "," + existingValue + "," + existedBefore + "," + previous + "," + existsAfter;
        }

        @Override
        public void printAsCode(Maps source, LinePrinter out, boolean includeChecks) {
            String addition = "map.put( " + this.key + ", " + this.value + " );";
            if (includeChecks) {
                boolean existing = source.normalMap.containsKey(this.key);
                int existingValue = existing ? source.normalMap.get(this.key) : -1;
                out.println(String.format("int sizeBefore = map.size();", new Object[0]));
                out.println(String.format("boolean existedBefore = map.containsKey( %d );", this.key));
                out.println(String.format("int valueBefore = map.get( %d );", this.key));
                out.println(String.format("int previous = %s", addition));
                out.println(String.format("boolean existsAfter = map.containsKey( %d );", this.key));
                out.println(String.format("int valueAfter = map.get( %d );", this.key));
                out.println(String.format("int sizeAfter = map.size();", new Object[0]));
                int actualSizeBefore = source.normalMap.size();
                out.println(String.format("assertEquals( \"%s\", %d, sizeBefore );", "Size before put should have been " + actualSizeBefore, actualSizeBefore));
                out.println(String.format("assert%s( \"%s\", existedBefore );", PrimitiveLongIntMapRIT.capitilize(existing), this.key + " should " + (existing ? "" : "not ") + "exist before putting here"));
                out.println(String.format("assertEquals( \"%s\", %d, valueBefore );", "value before should be " + existingValue, existingValue));
                out.println(String.format("assertEquals( \"%s\", %d, previous );", "value returned from put should be " + existingValue, existingValue));
                out.println(String.format("assertTrue( \"%s\", existsAfter );", this.key + " should exist"));
                out.println(String.format("assertEquals( \"%s\", %d, valueAfter );", "value after putting should be " + this.value, this.value));
                int actualSizeAfter = existing ? actualSizeBefore : actualSizeBefore + 1;
                out.println(String.format("assertEquals( \"%s\", %d, sizeAfter );", "Size after put should have been " + actualSizeAfter, actualSizeAfter));
            } else {
                out.println(addition);
            }
        }
    }
}

