/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.concurrent.CompletableFuture;

public class CompletableFutureTest {
    @Test
    public void shouldBeInitiallyUnresolved() {
        CompletableFuture future = new CompletableFuture();
        MatcherAssert.assertThat((Object)future.isDone(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)future.isCancelled(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldResolveWithValue() throws Exception {
        CompletableFuture future = new CompletableFuture();
        future.complete((Object)1);
        MatcherAssert.assertThat((Object)future.isDone(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)future.isCancelled(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)future.get(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldResolveWithException() throws Exception {
        CompletableFuture future = new CompletableFuture();
        Exception ex = new Exception();
        future.completeExceptionally((Throwable)ex);
        MatcherAssert.assertThat((Object)future.isDone(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)future.isCancelled(), (Matcher)Is.is((Object)false));
        try {
            future.get();
            Assert.fail((String)"expected exception not thrown");
        }
        catch (ExecutionException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)IsSame.sameInstance((Object)ex));
        }
    }

    @Test
    public void shouldCancel() throws Exception {
        CompletableFuture future = new CompletableFuture();
        future.cancel(false);
        MatcherAssert.assertThat((Object)future.isDone(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)future.isCancelled(), (Matcher)Is.is((Object)true));
        try {
            future.get();
            Assert.fail((String)"expected exception not thrown");
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldWaitUntilResolved() throws Exception {
        final CompletableFuture future = new CompletableFuture();
        final CountDownLatch startedLatch = new CountDownLatch(1);
        Thread thread = new Thread(){

            @Override
            public void run() {
                startedLatch.countDown();
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        thread.start();
        startedLatch.await();
        Thread.sleep(100L);
        MatcherAssert.assertThat((Object)thread.isAlive(), (Matcher)Is.is((Object)true));
        future.complete((Object)1);
        thread.join(10000L);
        MatcherAssert.assertThat((Object)thread.isAlive(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldThrowTimeoutException() throws Exception {
        CompletableFuture future = new CompletableFuture();
        try {
            future.get(1L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"expected exception not thrown");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }
}

