/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.concurrent.Work;
import org.neo4j.concurrent.WorkSync;

public class WorkSyncTest {
    private AtomicInteger sum = new AtomicInteger();
    private AtomicInteger count = new AtomicInteger();
    private Adder adder = new Adder();
    private WorkSync<Adder, AddWork> sync = new WorkSync((Object)this.adder);

    private static void usleep(long micros) {
        long now;
        long deadline = System.nanoTime() + TimeUnit.MICROSECONDS.toNanos(micros);
        while ((now = System.nanoTime()) < deadline) {
        }
    }

    @Test
    public void mustApplyWork() throws Exception {
        this.sync.apply((Work)new AddWork(10));
        Assert.assertThat((Object)this.sum.get(), (Matcher)Matchers.is((Object)10));
        this.sync.apply((Work)new AddWork(20));
        Assert.assertThat((Object)this.sum.get(), (Matcher)Matchers.is((Object)30));
    }

    @Test
    public void mustCombineWork() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(64);
        for (int i = 0; i < 1000; ++i) {
            executor.execute(new RunnableWork(new AddWork(1)));
        }
        executor.shutdown();
        Assert.assertTrue((boolean)executor.awaitTermination(2L, TimeUnit.SECONDS));
        Assert.assertThat((Object)this.count.get(), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(this.sum.get())));
    }

    @Test
    public void mustApplyWorkEvenWhenInterrupted() throws Exception {
        Thread.currentThread().interrupt();
        this.sync.apply((Work)new AddWork(10));
        Assert.assertThat((Object)this.sum.get(), (Matcher)Matchers.is((Object)10));
        Assert.assertTrue((boolean)Thread.interrupted());
    }

    @Test(timeout=1000L)
    public void mustRecoverFromExceptions() throws Exception {
        final AtomicBoolean broken = new AtomicBoolean(true);
        Adder adder = new Adder(){

            @Override
            public void add(int delta) {
                if (broken.get()) {
                    throw new IllegalStateException("boom!");
                }
                super.add(delta);
            }
        };
        this.sync = new WorkSync((Object)adder);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            executor.submit(new RunnableWork(new AddWork(10))).get();
            Assert.fail((String)"Should have thrown");
        }
        catch (ExecutionException exception) {
            Assert.assertThat((Object)exception.getCause(), (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
        broken.set(false);
        this.sync.apply((Work)new AddWork(20));
        Assert.assertThat((Object)this.sum.get(), (Matcher)Matchers.is((Object)20));
        Assert.assertThat((Object)this.count.get(), (Matcher)Matchers.is((Object)1));
    }

    private class RunnableWork
    implements Runnable {
        private final AddWork addWork;

        public RunnableWork(AddWork addWork) {
            this.addWork = addWork;
        }

        @Override
        public void run() {
            WorkSyncTest.this.sync.apply((Work)this.addWork);
        }
    }

    private class Adder {
        private Adder() {
        }

        public void add(int delta) {
            WorkSyncTest.this.sum.getAndAdd(delta);
            WorkSyncTest.this.count.getAndIncrement();
        }
    }

    private static class AddWork
    implements Work<Adder, AddWork> {
        private int delta;

        private AddWork(int delta) {
            this.delta = delta;
        }

        public AddWork combine(AddWork work) {
            this.delta += work.delta;
            return this;
        }

        public void apply(Adder adder) {
            WorkSyncTest.usleep(50L);
            adder.add(this.delta);
        }
    }
}

