/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.concurrent.jsr166e;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.neo4j.concurrent.jsr166e.JSR166TestCase;
import org.neo4j.concurrent.jsr166e.StampedLock;

public class StampedLockTest
extends JSR166TestCase {
    void releaseWriteLock(StampedLock lock, long s) {
        StampedLockTest.assertTrue((boolean)lock.isWriteLocked());
        lock.unlockWrite(s);
        StampedLockTest.assertFalse((boolean)lock.isWriteLocked());
    }

    public void testConstructor() {
        StampedLock lock = new StampedLock();
        StampedLockTest.assertFalse((boolean)lock.isWriteLocked());
        StampedLockTest.assertFalse((boolean)lock.isReadLocked());
        StampedLockTest.assertEquals((int)lock.getReadLockCount(), (int)0);
    }

    public void testLock() {
        StampedLock lock = new StampedLock();
        StampedLockTest.assertFalse((boolean)lock.isWriteLocked());
        StampedLockTest.assertFalse((boolean)lock.isReadLocked());
        StampedLockTest.assertEquals((int)lock.getReadLockCount(), (int)0);
        long s = lock.writeLock();
        StampedLockTest.assertTrue((boolean)lock.isWriteLocked());
        StampedLockTest.assertFalse((boolean)lock.isReadLocked());
        StampedLockTest.assertEquals((int)lock.getReadLockCount(), (int)0);
        lock.unlockWrite(s);
        StampedLockTest.assertFalse((boolean)lock.isWriteLocked());
        StampedLockTest.assertFalse((boolean)lock.isReadLocked());
        StampedLockTest.assertEquals((int)lock.getReadLockCount(), (int)0);
        long rs = lock.readLock();
        StampedLockTest.assertFalse((boolean)lock.isWriteLocked());
        StampedLockTest.assertTrue((boolean)lock.isReadLocked());
        StampedLockTest.assertEquals((int)lock.getReadLockCount(), (int)1);
        lock.unlockRead(rs);
        StampedLockTest.assertFalse((boolean)lock.isWriteLocked());
        StampedLockTest.assertFalse((boolean)lock.isReadLocked());
        StampedLockTest.assertEquals((int)lock.getReadLockCount(), (int)0);
    }

    public void testUnlock() {
        StampedLock lock = new StampedLock();
        StampedLockTest.assertFalse((boolean)lock.isWriteLocked());
        StampedLockTest.assertFalse((boolean)lock.isReadLocked());
        StampedLockTest.assertEquals((int)lock.getReadLockCount(), (int)0);
        long s = lock.writeLock();
        StampedLockTest.assertTrue((boolean)lock.isWriteLocked());
        StampedLockTest.assertFalse((boolean)lock.isReadLocked());
        StampedLockTest.assertEquals((int)lock.getReadLockCount(), (int)0);
        lock.unlock(s);
        StampedLockTest.assertFalse((boolean)lock.isWriteLocked());
        StampedLockTest.assertFalse((boolean)lock.isReadLocked());
        StampedLockTest.assertEquals((int)lock.getReadLockCount(), (int)0);
        long rs = lock.readLock();
        StampedLockTest.assertFalse((boolean)lock.isWriteLocked());
        StampedLockTest.assertTrue((boolean)lock.isReadLocked());
        StampedLockTest.assertEquals((int)lock.getReadLockCount(), (int)1);
        lock.unlock(rs);
        StampedLockTest.assertFalse((boolean)lock.isWriteLocked());
        StampedLockTest.assertFalse((boolean)lock.isReadLocked());
        StampedLockTest.assertEquals((int)lock.getReadLockCount(), (int)0);
    }

    public void testTryUnlock() {
        StampedLock lock = new StampedLock();
        StampedLockTest.assertFalse((boolean)lock.isWriteLocked());
        StampedLockTest.assertFalse((boolean)lock.isReadLocked());
        StampedLockTest.assertEquals((int)lock.getReadLockCount(), (int)0);
        long s = lock.writeLock();
        StampedLockTest.assertTrue((boolean)lock.isWriteLocked());
        StampedLockTest.assertFalse((boolean)lock.isReadLocked());
        StampedLockTest.assertEquals((int)lock.getReadLockCount(), (int)0);
        StampedLockTest.assertFalse((boolean)lock.tryUnlockRead());
        StampedLockTest.assertTrue((boolean)lock.tryUnlockWrite());
        StampedLockTest.assertFalse((boolean)lock.tryUnlockWrite());
        StampedLockTest.assertFalse((boolean)lock.tryUnlockRead());
        StampedLockTest.assertFalse((boolean)lock.isWriteLocked());
        StampedLockTest.assertFalse((boolean)lock.isReadLocked());
        StampedLockTest.assertEquals((int)lock.getReadLockCount(), (int)0);
        long rs = lock.readLock();
        StampedLockTest.assertFalse((boolean)lock.isWriteLocked());
        StampedLockTest.assertTrue((boolean)lock.isReadLocked());
        StampedLockTest.assertEquals((int)lock.getReadLockCount(), (int)1);
        StampedLockTest.assertFalse((boolean)lock.tryUnlockWrite());
        StampedLockTest.assertTrue((boolean)lock.tryUnlockRead());
        StampedLockTest.assertFalse((boolean)lock.tryUnlockRead());
        StampedLockTest.assertFalse((boolean)lock.tryUnlockWrite());
        StampedLockTest.assertFalse((boolean)lock.isWriteLocked());
        StampedLockTest.assertFalse((boolean)lock.isReadLocked());
        StampedLockTest.assertEquals((int)lock.getReadLockCount(), (int)0);
    }

    public void testWriteUnlock_IMSE() {
        StampedLock lock = new StampedLock();
        try {
            lock.unlockWrite(0L);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testWriteUnlock_IMSE2() {
        StampedLock lock = new StampedLock();
        try {
            long s = lock.writeLock();
            lock.unlockWrite(s);
            lock.unlockWrite(s);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testWriteUnlock_IMSE3() {
        StampedLock lock = new StampedLock();
        try {
            long s = lock.readLock();
            lock.unlockWrite(s);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testReadUnlock_IMSE() {
        StampedLock lock = new StampedLock();
        try {
            long s = lock.readLock();
            lock.unlockRead(s);
            lock.unlockRead(s);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testReadUnlock_IMSE2() {
        StampedLock lock = new StampedLock();
        try {
            lock.unlockRead(0L);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testReadUnlock_IMSE3() {
        StampedLock lock = new StampedLock();
        try {
            long s = lock.writeLock();
            lock.unlockRead(s);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testValidate0() {
        StampedLock lock = new StampedLock();
        StampedLockTest.assertFalse((boolean)lock.validate(0L));
    }

    public void testValidate() {
        try {
            StampedLock lock = new StampedLock();
            long s = lock.writeLock();
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            lock.unlockWrite(s);
            s = lock.readLock();
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            lock.unlockRead(s);
            s = lock.tryWriteLock();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            lock.unlockWrite(s);
            s = lock.tryReadLock();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            lock.unlockRead(s);
            s = lock.tryWriteLock(100L, TimeUnit.MILLISECONDS);
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            lock.unlockWrite(s);
            s = lock.tryReadLock(100L, TimeUnit.MILLISECONDS);
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            lock.unlockRead(s);
            s = lock.tryOptimisticRead();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
        }
        catch (InterruptedException ie) {
            this.threadUnexpectedException(ie);
        }
    }

    public void testValidate2() {
        try {
            StampedLock lock = new StampedLock();
            long s = lock.writeLock();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            StampedLockTest.assertFalse((boolean)lock.validate(lock.tryWriteLock()));
            StampedLockTest.assertFalse((boolean)lock.validate(lock.tryWriteLock(100L, TimeUnit.MILLISECONDS)));
            StampedLockTest.assertFalse((boolean)lock.validate(lock.tryReadLock()));
            StampedLockTest.assertFalse((boolean)lock.validate(lock.tryReadLock(100L, TimeUnit.MILLISECONDS)));
            StampedLockTest.assertFalse((boolean)lock.validate(lock.tryOptimisticRead()));
            lock.unlockWrite(s);
        }
        catch (InterruptedException ie) {
            this.threadUnexpectedException(ie);
        }
    }

    public void testWriteLockInterruptibly_Interruptible() {
        final CountDownLatch running = new CountDownLatch(1);
        final StampedLock lock = new StampedLock();
        long s = lock.writeLock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                running.countDown();
                lock.writeLockInterruptibly();
            }
        });
        try {
            running.await();
            this.waitForThreadToEnterWaitState(t, 100L);
            t.interrupt();
            this.awaitTermination(t);
            this.releaseWriteLock(lock, s);
        }
        catch (InterruptedException ie) {
            this.threadUnexpectedException(ie);
        }
    }

    public void testWriteTryLock_Interruptible() {
        final CountDownLatch running = new CountDownLatch(1);
        final StampedLock lock = new StampedLock();
        long s = lock.writeLock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                running.countDown();
                lock.tryWriteLock(2L * JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        });
        try {
            running.await();
            this.waitForThreadToEnterWaitState(t, 100L);
            t.interrupt();
            this.awaitTermination(t);
            this.releaseWriteLock(lock, s);
        }
        catch (InterruptedException ie) {
            this.threadUnexpectedException(ie);
        }
    }

    public void testReadLockInterruptibly_Interruptible() {
        final CountDownLatch running = new CountDownLatch(1);
        final StampedLock lock = new StampedLock();
        long s = lock.writeLock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                running.countDown();
                lock.readLockInterruptibly();
            }
        });
        try {
            running.await();
            this.waitForThreadToEnterWaitState(t, 100L);
            t.interrupt();
            this.awaitTermination(t);
            this.releaseWriteLock(lock, s);
        }
        catch (InterruptedException ie) {
            this.threadUnexpectedException(ie);
        }
    }

    public void testReadTryLock_Interruptible() {
        final CountDownLatch running = new CountDownLatch(1);
        final StampedLock lock = new StampedLock();
        long s = lock.writeLock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                running.countDown();
                lock.tryReadLock(2L * JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        });
        try {
            running.await();
            this.waitForThreadToEnterWaitState(t, 100L);
            t.interrupt();
            this.awaitTermination(t);
            this.releaseWriteLock(lock, s);
        }
        catch (InterruptedException ie) {
            this.threadUnexpectedException(ie);
        }
    }

    public void testWriteTryLock() {
        StampedLock lock = new StampedLock();
        long s = lock.tryWriteLock();
        StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
        StampedLockTest.assertTrue((boolean)lock.isWriteLocked());
        long s2 = lock.tryWriteLock();
        StampedLockTest.assertEquals((long)s2, (long)0L);
        this.releaseWriteLock(lock, s);
    }

    public void testWriteTryLockWhenLocked() {
        final StampedLock lock = new StampedLock();
        long s = lock.writeLock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                long ws = lock.tryWriteLock();
                TestCase.assertTrue((ws == 0L ? 1 : 0) != 0);
            }
        });
        this.awaitTermination(t);
        this.releaseWriteLock(lock, s);
    }

    public void testReadTryLockWhenLocked() {
        final StampedLock lock = new StampedLock();
        long s = lock.writeLock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                long rs = lock.tryReadLock();
                TestCase.assertEquals((long)rs, (long)0L);
            }
        });
        this.awaitTermination(t);
        this.releaseWriteLock(lock, s);
    }

    public void testMultipleReadLocks() {
        final StampedLock lock = new StampedLock();
        long s = lock.readLock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                long s2 = lock.tryReadLock();
                TestCase.assertTrue((s2 != 0L ? 1 : 0) != 0);
                lock.unlockRead(s2);
                long s3 = lock.tryReadLock(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
                TestCase.assertTrue((s3 != 0L ? 1 : 0) != 0);
                lock.unlockRead(s3);
                long s4 = lock.readLock();
                lock.unlockRead(s4);
            }
        });
        this.awaitTermination(t);
        lock.unlockRead(s);
    }

    public void testWriteAfterReadLock() {
        final CountDownLatch running = new CountDownLatch(1);
        final StampedLock lock = new StampedLock();
        long rs = lock.readLock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                running.countDown();
                long s = lock.writeLock();
                lock.unlockWrite(s);
            }
        });
        try {
            running.await();
            this.waitForThreadToEnterWaitState(t, 100L);
            StampedLockTest.assertFalse((boolean)lock.isWriteLocked());
            lock.unlockRead(rs);
            this.awaitTermination(t);
            StampedLockTest.assertFalse((boolean)lock.isWriteLocked());
        }
        catch (InterruptedException ie) {
            this.threadUnexpectedException(ie);
        }
    }

    public void testWriteAfterMultipleReadLocks() {
        final StampedLock lock = new StampedLock();
        long s = lock.readLock();
        Thread t1 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                long rs = lock.readLock();
                lock.unlockRead(rs);
            }
        });
        this.awaitTermination(t1);
        Thread t2 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                long ws = lock.writeLock();
                lock.unlockWrite(ws);
            }
        });
        StampedLockTest.assertFalse((boolean)lock.isWriteLocked());
        lock.unlockRead(s);
        this.awaitTermination(t2);
        StampedLockTest.assertFalse((boolean)lock.isWriteLocked());
    }

    public void testReadAfterWriteLock() {
        final StampedLock lock = new StampedLock();
        long s = lock.writeLock();
        Thread t1 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                long rs = lock.readLock();
                lock.unlockRead(rs);
            }
        });
        Thread t2 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                long rs = lock.readLock();
                lock.unlockRead(rs);
            }
        });
        this.releaseWriteLock(lock, s);
        this.awaitTermination(t1);
        this.awaitTermination(t2);
    }

    public void testTryLockWhenReadLocked() {
        final StampedLock lock = new StampedLock();
        long s = lock.readLock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                long rs = lock.tryReadLock();
                StampedLockTest.this.threadAssertTrue(rs != 0L);
                lock.unlockRead(rs);
            }
        });
        this.awaitTermination(t);
        lock.unlockRead(s);
    }

    public void testWriteTryLockWhenReadLocked() {
        final StampedLock lock = new StampedLock();
        long s = lock.readLock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                long ws = lock.tryWriteLock();
                StampedLockTest.this.threadAssertEquals(ws, 0L);
            }
        });
        this.awaitTermination(t);
        lock.unlockRead(s);
    }

    public void testWriteTryLock_Timeout() {
        final StampedLock lock = new StampedLock();
        long s = lock.writeLock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                long startTime = System.nanoTime();
                long timeoutMillis = 10L;
                long ws = lock.tryWriteLock(timeoutMillis, TimeUnit.MILLISECONDS);
                TestCase.assertEquals((long)ws, (long)0L);
                TestCase.assertTrue((JSR166TestCase.millisElapsedSince(startTime) >= timeoutMillis ? 1 : 0) != 0);
            }
        });
        this.awaitTermination(t);
        this.releaseWriteLock(lock, s);
    }

    public void testReadTryLock_Timeout() {
        final StampedLock lock = new StampedLock();
        long s = lock.writeLock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                long startTime = System.nanoTime();
                long timeoutMillis = 10L;
                long rs = lock.tryReadLock(timeoutMillis, TimeUnit.MILLISECONDS);
                TestCase.assertEquals((long)rs, (long)0L);
                TestCase.assertTrue((JSR166TestCase.millisElapsedSince(startTime) >= timeoutMillis ? 1 : 0) != 0);
            }
        });
        this.awaitTermination(t);
        StampedLockTest.assertTrue((boolean)lock.isWriteLocked());
        lock.unlockWrite(s);
    }

    public void testWriteLockInterruptibly() {
        final CountDownLatch running = new CountDownLatch(1);
        final StampedLock lock = new StampedLock();
        long s = 0L;
        try {
            s = lock.writeLockInterruptibly();
        }
        catch (InterruptedException ie) {
            this.threadUnexpectedException(ie);
        }
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                running.countDown();
                lock.writeLockInterruptibly();
            }
        });
        try {
            running.await();
            this.waitForThreadToEnterWaitState(t, 100L);
            t.interrupt();
            StampedLockTest.assertTrue((boolean)lock.isWriteLocked());
            this.awaitTermination(t);
            this.releaseWriteLock(lock, s);
        }
        catch (InterruptedException ie) {
            this.threadUnexpectedException(ie);
        }
    }

    public void testReadLockInterruptibly() {
        final CountDownLatch running = new CountDownLatch(1);
        final StampedLock lock = new StampedLock();
        long s = 0L;
        try {
            s = lock.readLockInterruptibly();
            lock.unlockRead(s);
            s = lock.writeLockInterruptibly();
        }
        catch (InterruptedException ie) {
            this.threadUnexpectedException(ie);
        }
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                running.countDown();
                lock.readLockInterruptibly();
            }
        });
        try {
            running.await();
            this.waitForThreadToEnterWaitState(t, 100L);
            t.interrupt();
            this.awaitTermination(t);
            this.releaseWriteLock(lock, s);
        }
        catch (InterruptedException ie) {
            this.threadUnexpectedException(ie);
        }
    }

    public void testSerialization() {
        StampedLock lock = new StampedLock();
        lock.writeLock();
        StampedLock clone = this.serialClone(lock);
        StampedLockTest.assertTrue((boolean)lock.isWriteLocked());
        StampedLockTest.assertFalse((boolean)clone.isWriteLocked());
        long s = clone.writeLock();
        StampedLockTest.assertTrue((boolean)clone.isWriteLocked());
        clone.unlockWrite(s);
        StampedLockTest.assertFalse((boolean)clone.isWriteLocked());
    }

    public void testToString() {
        StampedLock lock = new StampedLock();
        StampedLockTest.assertTrue((boolean)lock.toString().contains("Unlocked"));
        long s = lock.writeLock();
        StampedLockTest.assertTrue((boolean)lock.toString().contains("Write-locked"));
        lock.unlockWrite(s);
        s = lock.readLock();
        StampedLockTest.assertTrue((boolean)lock.toString().contains("Read-locks"));
    }

    public void testValidateOptimistic() {
        try {
            StampedLock lock = new StampedLock();
            long p = lock.tryOptimisticRead();
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(p));
            long s = lock.writeLock();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            p = lock.tryOptimisticRead();
            StampedLockTest.assertFalse((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            lock.unlockWrite(s);
            p = lock.tryOptimisticRead();
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(p));
            s = lock.readLock();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            p = lock.tryOptimisticRead();
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(p));
            lock.unlockRead(s);
            s = lock.tryWriteLock();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            p = lock.tryOptimisticRead();
            StampedLockTest.assertFalse((p != 0L ? 1 : 0) != 0);
            lock.unlockWrite(s);
            s = lock.tryReadLock();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            p = lock.tryOptimisticRead();
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            lock.unlockRead(s);
            StampedLockTest.assertTrue((boolean)lock.validate(p));
            s = lock.tryWriteLock(100L, TimeUnit.MILLISECONDS);
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            p = lock.tryOptimisticRead();
            StampedLockTest.assertFalse((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            lock.unlockWrite(s);
            s = lock.tryReadLock(100L, TimeUnit.MILLISECONDS);
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            p = lock.tryOptimisticRead();
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            lock.unlockRead(s);
            p = lock.tryOptimisticRead();
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
        }
        catch (InterruptedException ie) {
            this.threadUnexpectedException(ie);
        }
    }

    public void testValidateOptimisticWriteLocked() {
        StampedLock lock = new StampedLock();
        long p = lock.tryOptimisticRead();
        StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
        long s = lock.writeLock();
        StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
        StampedLockTest.assertFalse((boolean)lock.validate(p));
        p = lock.tryOptimisticRead();
        StampedLockTest.assertFalse((p != 0L ? 1 : 0) != 0);
        StampedLockTest.assertTrue((boolean)lock.validate(s));
        lock.unlockWrite(s);
    }

    public void testValidateOptimisticWriteLocked2() {
        final CountDownLatch running = new CountDownLatch(1);
        final StampedLock lock = new StampedLock();
        long p = lock.tryOptimisticRead();
        StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.writeLockInterruptibly();
                running.countDown();
                lock.writeLockInterruptibly();
            }
        });
        try {
            running.await();
            StampedLockTest.assertFalse((boolean)lock.validate(p));
            p = lock.tryOptimisticRead();
            StampedLockTest.assertFalse((p != 0L ? 1 : 0) != 0);
            t.interrupt();
            this.awaitTermination(t);
        }
        catch (InterruptedException ie) {
            this.threadUnexpectedException(ie);
        }
    }

    public void testTryConvertToOptimisticRead() {
        try {
            StampedLock lock = new StampedLock();
            long s = 0L;
            long p = lock.tryConvertToOptimisticRead(s);
            StampedLockTest.assertFalse((p != 0L ? 1 : 0) != 0);
            s = lock.tryOptimisticRead();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            p = lock.tryConvertToOptimisticRead(s);
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            s = lock.writeLock();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            p = lock.tryConvertToOptimisticRead(s);
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(p));
            s = lock.readLock();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            p = lock.tryConvertToOptimisticRead(s);
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(p));
            s = lock.tryWriteLock();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            p = lock.tryConvertToOptimisticRead(s);
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(p));
            s = lock.tryReadLock();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            p = lock.tryConvertToOptimisticRead(s);
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(p));
            s = lock.tryWriteLock(100L, TimeUnit.MILLISECONDS);
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            p = lock.tryConvertToOptimisticRead(s);
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(p));
            s = lock.tryReadLock(100L, TimeUnit.MILLISECONDS);
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            p = lock.tryConvertToOptimisticRead(s);
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(p));
        }
        catch (InterruptedException ie) {
            this.threadUnexpectedException(ie);
        }
    }

    public void testTryConvertToReadLock() {
        try {
            StampedLock lock = new StampedLock();
            long s = 0L;
            long p = lock.tryConvertToReadLock(s);
            StampedLockTest.assertFalse((p != 0L ? 1 : 0) != 0);
            s = lock.tryOptimisticRead();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            p = lock.tryConvertToReadLock(s);
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            lock.unlockRead(p);
            s = lock.writeLock();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            p = lock.tryConvertToReadLock(s);
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(p));
            lock.unlockRead(p);
            s = lock.readLock();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            p = lock.tryConvertToReadLock(s);
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(p));
            lock.unlockRead(p);
            s = lock.tryWriteLock();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            p = lock.tryConvertToReadLock(s);
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(p));
            lock.unlockRead(p);
            s = lock.tryReadLock();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            p = lock.tryConvertToReadLock(s);
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(p));
            lock.unlockRead(p);
            s = lock.tryWriteLock(100L, TimeUnit.MILLISECONDS);
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            p = lock.tryConvertToReadLock(s);
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(p));
            lock.unlockRead(p);
            s = lock.tryReadLock(100L, TimeUnit.MILLISECONDS);
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            p = lock.tryConvertToReadLock(s);
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(p));
            lock.unlockRead(p);
        }
        catch (InterruptedException ie) {
            this.threadUnexpectedException(ie);
        }
    }

    public void testTryConvertToWriteLock() {
        try {
            StampedLock lock = new StampedLock();
            long s = 0L;
            long p = lock.tryConvertToWriteLock(s);
            StampedLockTest.assertFalse((p != 0L ? 1 : 0) != 0);
            s = lock.tryOptimisticRead();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            p = lock.tryConvertToWriteLock(s);
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            lock.unlockWrite(p);
            s = lock.writeLock();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            p = lock.tryConvertToWriteLock(s);
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(p));
            lock.unlockWrite(p);
            s = lock.readLock();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            p = lock.tryConvertToWriteLock(s);
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(p));
            lock.unlockWrite(p);
            s = lock.tryWriteLock();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            p = lock.tryConvertToWriteLock(s);
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(p));
            lock.unlockWrite(p);
            s = lock.tryReadLock();
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            p = lock.tryConvertToWriteLock(s);
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(p));
            lock.unlockWrite(p);
            s = lock.tryWriteLock(100L, TimeUnit.MILLISECONDS);
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            p = lock.tryConvertToWriteLock(s);
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(p));
            lock.unlockWrite(p);
            s = lock.tryReadLock(100L, TimeUnit.MILLISECONDS);
            StampedLockTest.assertTrue((s != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(s));
            p = lock.tryConvertToWriteLock(s);
            StampedLockTest.assertTrue((p != 0L ? 1 : 0) != 0);
            StampedLockTest.assertTrue((boolean)lock.validate(p));
            lock.unlockWrite(p);
        }
        catch (InterruptedException ie) {
            this.threadUnexpectedException(ie);
        }
    }

    class InterruptedLockRunnable
    extends JSR166TestCase.CheckedInterruptedRunnable {
        final StampedLock lock;

        InterruptedLockRunnable(StampedLock l) {
            this.lock = l;
        }

        @Override
        public void realRun() throws InterruptedException {
            this.lock.writeLockInterruptibly();
        }
    }

    class InterruptibleLockRunnable
    extends JSR166TestCase.CheckedRunnable {
        final StampedLock lock;

        InterruptibleLockRunnable(StampedLock l) {
            this.lock = l;
        }

        @Override
        public void realRun() throws InterruptedException {
            this.lock.writeLockInterruptibly();
        }
    }
}

