/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongObjectVisitor;
import org.neo4j.collection.primitive.hopscotch.AbstractLongHopScotchCollection;
import org.neo4j.collection.primitive.hopscotch.HopScotchHashingAlgorithm;
import org.neo4j.collection.primitive.hopscotch.Table;

public class PrimitiveLongObjectHashMap<VALUE>
extends AbstractLongHopScotchCollection<VALUE>
implements PrimitiveLongObjectMap<VALUE> {
    private final HopScotchHashingAlgorithm.Monitor monitor;

    public PrimitiveLongObjectHashMap(Table<VALUE> table, HopScotchHashingAlgorithm.Monitor monitor) {
        super(table);
        this.monitor = monitor;
    }

    @Override
    public VALUE put(long key, VALUE value) {
        return HopScotchHashingAlgorithm.put(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key, value, this);
    }

    @Override
    public boolean containsKey(long key) {
        return HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key) != null;
    }

    @Override
    public VALUE get(long key) {
        return HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key);
    }

    @Override
    public VALUE remove(long key) {
        return HopScotchHashingAlgorithm.remove(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key);
    }

    @Override
    public int size() {
        return this.table.size();
    }

    @Override
    public String toString() {
        return this.table.toString();
    }

    @Override
    public <E extends Exception> void visitEntries(PrimitiveLongObjectVisitor<VALUE, E> visitor) throws E {
        long nullKey = this.table.nullKey();
        int capacity = this.table.capacity();
        for (int i = 0; i < capacity; ++i) {
            long key = this.table.key(i);
            if (key == nullKey || !visitor.visited(key, this.table.value(i))) continue;
            return;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this.typeAndSizeEqual(other)) {
            PrimitiveLongObjectHashMap that = (PrimitiveLongObjectHashMap)other;
            LongObjEquality equality = new LongObjEquality(that);
            this.visitEntries(equality);
            return equality.isEqual();
        }
        return false;
    }

    @Override
    public int hashCode() {
        HashCodeComputer hash = new HashCodeComputer();
        this.visitEntries(hash);
        return hash.hashCode();
    }

    private static class HashCodeComputer<T>
    implements PrimitiveLongObjectVisitor<T, RuntimeException> {
        private int hash = 1337;

        private HashCodeComputer() {
        }

        @Override
        public boolean visited(long key, T value) throws RuntimeException {
            this.hash += HopScotchHashingAlgorithm.DEFAULT_HASHING.hash(key + (long)value.hashCode());
            return false;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class LongObjEquality<T>
    implements PrimitiveLongObjectVisitor<T, RuntimeException> {
        private PrimitiveLongObjectHashMap other;
        private boolean equal = true;

        public LongObjEquality(PrimitiveLongObjectHashMap that) {
            this.other = that;
        }

        @Override
        public boolean visited(long key, T value) {
            Object otherValue = this.other.get(key);
            this.equal = otherValue == value || otherValue != null && otherValue.equals(value);
            return !this.equal;
        }

        public boolean isEqual() {
            return this.equal;
        }
    }
}

