/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.register;

import java.util.function.BiFunction;
import org.neo4j.register.Register;

public class Registers {
    public static Register.DoubleLongRegister newDoubleLongRegister() {
        return Registers.newDoubleLongRegister(-1L, -1L);
    }

    public static Register.DoubleLongRegister newDoubleLongRegister(final long initialFirst, final long initialSecond) {
        return new Register.DoubleLongRegister(){
            private long first;
            private long second;
            {
                this.first = initialFirst;
                this.second = initialSecond;
            }

            @Override
            public long readFirst() {
                return this.first;
            }

            @Override
            public long readSecond() {
                return this.second;
            }

            @Override
            public void copyTo(Register.DoubleLong.Out target) {
                target.write(this.first, this.second);
            }

            @Override
            public boolean hasValues(long first, long second) {
                return this.first == first && this.second == second;
            }

            @Override
            public boolean satisfies(BiFunction<Long, Long, Boolean> condition) {
                return condition.apply(this.first, this.second);
            }

            @Override
            public void write(long first, long second) {
                this.first = first;
                this.second = second;
            }

            @Override
            public void increment(long firstDelta, long secondDelta) {
                this.first += firstDelta;
                this.second += secondDelta;
            }

            public String toString() {
                return "DoubleLongRegister{first=" + this.first + ", second=" + this.second + "}";
            }
        };
    }

    public static Register.LongRegister newLongRegister() {
        return Registers.newLongRegister(-1L);
    }

    public static Register.LongRegister newLongRegister(final long initialValue) {
        return new Register.LongRegister(){
            private long value;
            {
                this.value = initialValue;
            }

            @Override
            public long read() {
                return this.value;
            }

            @Override
            public void write(long value) {
                this.value = value;
            }

            @Override
            public long increment(long delta) {
                this.value += delta;
                return this.value;
            }

            public String toString() {
                return "LongRegister{value=" + this.value + "}";
            }
        };
    }

    public static Register.IntRegister newIntRegister() {
        return Registers.newIntRegister(-1);
    }

    public static Register.IntRegister newIntRegister(final int initialValue) {
        return new Register.IntRegister(){
            private int value;
            {
                this.value = initialValue;
            }

            @Override
            public int read() {
                return this.value;
            }

            @Override
            public void write(int value) {
                this.value = value;
            }

            @Override
            public int increment(int delta) {
                this.value += delta;
                return this.value;
            }

            public String toString() {
                return "IntRegister{value=" + this.value + "}";
            }
        };
    }

    public static <T> Register.ObjectRegister<T> newObjectRegister() {
        return Registers.newObjectRegister(null);
    }

    public static <T> Register.ObjectRegister<T> newObjectRegister(final T initialValue) {
        return new Register.ObjectRegister<T>(){
            private T value;
            {
                this.value = initialValue;
            }

            @Override
            public T read() {
                return this.value;
            }

            @Override
            public void write(T value) {
                this.value = value;
            }

            public String toString() {
                return "ObjectRegister{value=" + this.value + "}";
            }
        };
    }
}

