/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.pool;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.neo4j.collection.pool.MarshlandPool;
import org.neo4j.collection.pool.Pool;
import org.neo4j.function.Factory;

public class PoolPerformance {
    public static void main(String ... args) throws InterruptedException, ExecutionException {
        MarshlandPool pool = new MarshlandPool(PoolPerformance.objectFactory());
        int iterations = 100000000;
        PoolPerformance.bench((Pool<Object>)pool, iterations, 1);
        PoolPerformance.bench((Pool<Object>)pool, (long)iterations / 2L, 2);
        PoolPerformance.bench((Pool<Object>)pool, (long)iterations / 4L, 4);
        PoolPerformance.bench((Pool<Object>)pool, (long)iterations / 8L, 8);
    }

    private static Factory<Object> objectFactory() {
        return new Factory<Object>(){

            public Object newInstance() {
                return new Object();
            }
        };
    }

    private static void bench(Pool<Object> pool, long iterations, int concurrency) throws InterruptedException, ExecutionException {
        ExecutorService executorService = Executors.newFixedThreadPool(concurrency);
        long start = System.nanoTime();
        List<Future<Object>> futures = executorService.invokeAll(PoolPerformance.workers(pool, iterations, concurrency));
        PoolPerformance.awaitAll(futures);
        long delta = System.nanoTime() - start;
        System.out.println("With " + concurrency + " threads: " + iterations * (long)concurrency / (delta / 1000000L) + " iterations/ms");
        executorService.shutdownNow();
        executorService.awaitTermination(10L, TimeUnit.SECONDS);
    }

    private static void awaitAll(List<Future<Object>> futures) throws InterruptedException, ExecutionException {
        for (Future<Object> future : futures) {
            future.get();
        }
    }

    private static List<Callable<Object>> workers(final Pool<Object> pool, final long iterations, int numWorkers) {
        ArrayList<Callable<Object>> workers = new ArrayList<Callable<Object>>();
        for (int i = 0; i < numWorkers; ++i) {
            workers.add(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    int i = 0;
                    while ((long)i < iterations) {
                        pool.release(pool.acquire());
                        ++i;
                    }
                    return null;
                }
            });
        }
        return workers;
    }
}

