/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongIntMap;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.test.randomized.RandomizedTester;
import org.neo4j.test.randomized.TestResource;

@Ignore(value="Not a test. A benchmark")
public class PrimitiveCollectionBenchmark {
    private static final int RUNS = 3;
    private static final int DATA_SIZE = 10000000;
    private static final long[] RANDOM_DATA = new long[10000000];
    private static final long[] SEQUENTIAL_DATA = new long[10000000];

    @Test
    public void performanceTestPrimitiveLongSet() throws Exception {
        RandomizedTester.TargetFactory<MapInterface> factory = new RandomizedTester.TargetFactory<MapInterface>(){

            @Override
            public MapInterface newInstance() {
                return new HopScotchSet();
            }
        };
        this.performanceTest("neo4j hop-scotch set, random", factory, RANDOM_DATA);
        this.performanceTest("neo4j hop-scotch set, seq", factory, SEQUENTIAL_DATA);
    }

    @Test
    public void performanceTestPrimitiveLongMap() throws Exception {
        RandomizedTester.TargetFactory<MapInterface> factory = new RandomizedTester.TargetFactory<MapInterface>(){

            @Override
            public MapInterface newInstance() {
                return new HopScotchMap();
            }
        };
        this.performanceTest("neo4j hop-scotch long->int map, random", factory, RANDOM_DATA);
        this.performanceTest("neo4j hop-scotch long->int map, seq", factory, SEQUENTIAL_DATA);
    }

    @Test
    public void performanceTestJavaLongSet() throws Exception {
        RandomizedTester.TargetFactory<MapInterface> factory = new RandomizedTester.TargetFactory<MapInterface>(){

            @Override
            public MapInterface newInstance() {
                return new JucSet();
            }
        };
        this.performanceTest("juc set, random", factory, RANDOM_DATA);
        this.performanceTest("juc set, seq", factory, SEQUENTIAL_DATA);
    }

    @Test
    public void performanceTestJavaLongMap() throws Exception {
        RandomizedTester.TargetFactory<MapInterface> factory = new RandomizedTester.TargetFactory<MapInterface>(){

            @Override
            public MapInterface newInstance() {
                return new JucMap();
            }
        };
        this.performanceTest("juc Long->Integer map, random", factory, RANDOM_DATA);
        this.performanceTest("juc Long->Integer map, seq", factory, SEQUENTIAL_DATA);
    }

    private void performanceTest(String name, RandomizedTester.TargetFactory<MapInterface> factory, long[] data) throws Exception {
        System.out.println("testing: " + name);
        for (int r = 0; r < 3; ++r) {
            try (MapInterface target = factory.newInstance();){
                long time = System.currentTimeMillis();
                long dataSize = data.length;
                int i = 0;
                while ((long)i < dataSize) {
                    target.put(data[i], (int)data[i]);
                    ++i;
                }
                long addTime = System.currentTimeMillis() - time;
                time = System.currentTimeMillis();
                int i2 = 0;
                while ((long)i2 < dataSize) {
                    target.get(data[i2]);
                    ++i2;
                }
                long containsTime = System.currentTimeMillis() - time;
                this.printResults(addTime, containsTime, target);
                continue;
            }
        }
    }

    private void printResults(long addTime, long containsTime, Object set) throws Exception {
        for (int i = 0; i < 5; ++i) {
            System.gc();
            Thread.sleep(1000L);
        }
        System.out.println("  add: " + addTime + ", contains: " + containsTime + ", mem: " + Runtime.getRuntime().totalMemory() + "   " + set);
    }

    static {
        Random random = new Random(145878L);
        for (int i = 0; i < 10000000; ++i) {
            PrimitiveCollectionBenchmark.RANDOM_DATA[i] = Math.abs(random.nextInt());
            PrimitiveCollectionBenchmark.SEQUENTIAL_DATA[i] = i;
        }
    }

    private static class HopScotchMap
    implements MapInterface {
        private final PrimitiveLongIntMap map = Primitive.longIntMap();

        private HopScotchMap() {
        }

        @Override
        public void put(long key, int value) {
            this.map.put(key, value);
        }

        @Override
        public void get(long key) {
            this.map.get(key);
        }

        public String toString() {
            return this.map.toString();
        }

        @Override
        public void close() {
            this.map.close();
        }
    }

    private static class HopScotchSet
    implements MapInterface {
        private final PrimitiveLongSet set = Primitive.offHeapLongSet();

        private HopScotchSet() {
        }

        @Override
        public void put(long key, int value) {
            this.set.add(key);
        }

        @Override
        public void get(long key) {
            this.set.contains(key);
        }

        public String toString() {
            return this.set.toString();
        }

        @Override
        public void close() {
            this.set.close();
        }
    }

    private static class JucMap
    implements MapInterface {
        private final Map<Long, Integer> map = new HashMap<Long, Integer>();

        private JucMap() {
        }

        @Override
        public void put(long key, int value) {
            this.map.put(key, value);
        }

        @Override
        public void get(long key) {
            this.map.get(key);
        }

        public String toString() {
            return "" + this.map.size();
        }

        @Override
        public void close() {
        }
    }

    private static class JucSet
    implements MapInterface {
        private final Set<Long> set = new HashSet<Long>();

        private JucSet() {
        }

        @Override
        public void put(long key, int value) {
            this.set.add(key);
        }

        @Override
        public void get(long key) {
            this.set.contains(key);
        }

        public String toString() {
            return "" + this.set.size();
        }

        @Override
        public void close() {
        }
    }

    private static interface MapInterface
    extends TestResource {
        public void put(long var1, int var3);

        public void get(long var1);
    }
}

