/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.experimental.theories.DataPoint;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveCollection;
import org.neo4j.collection.primitive.PrimitiveIntLongMap;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.PrimitiveLongIntMap;
import org.neo4j.collection.primitive.PrimitiveLongLongMap;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.function.Factory;

@RunWith(value=Theories.class)
public class PrimitiveCollectionEqualityTest {
    @DataPoint
    public static ValueProducer<PrimitiveIntSet> intV = new ValueProducer<PrimitiveIntSet>(PrimitiveIntSet.class){

        @Override
        public Value<PrimitiveIntSet> randomValue() {
            final int x = PrimitiveCollectionEqualityTest.randomInt();
            return new Value<PrimitiveIntSet>(){

                @Override
                public void add(PrimitiveIntSet coll) {
                    coll.add(x);
                }

                @Override
                public boolean remove(PrimitiveIntSet coll) {
                    return coll.remove(x);
                }
            };
        }
    };
    @DataPoint
    public static ValueProducer<PrimitiveLongSet> longV = new ValueProducer<PrimitiveLongSet>(PrimitiveLongSet.class){

        @Override
        public Value<PrimitiveLongSet> randomValue() {
            final long x = PrimitiveCollectionEqualityTest.randomLong();
            return new Value<PrimitiveLongSet>(){

                @Override
                public void add(PrimitiveLongSet coll) {
                    coll.add(x);
                }

                @Override
                public boolean remove(PrimitiveLongSet coll) {
                    return coll.remove(x);
                }
            };
        }
    };
    @DataPoint
    public static ValueProducer<PrimitiveIntLongMap> intLongV = new ValueProducer<PrimitiveIntLongMap>(PrimitiveIntLongMap.class){

        @Override
        public Value<PrimitiveIntLongMap> randomValue() {
            final int x = PrimitiveCollectionEqualityTest.randomInt();
            final long y = PrimitiveCollectionEqualityTest.randomLong();
            return new Value<PrimitiveIntLongMap>(){

                @Override
                public void add(PrimitiveIntLongMap coll) {
                    coll.put(x, y);
                }

                @Override
                public boolean remove(PrimitiveIntLongMap coll) {
                    return coll.remove(x) == y;
                }
            };
        }
    };
    @DataPoint
    public static ValueProducer<PrimitiveLongIntMap> longIntV = new ValueProducer<PrimitiveLongIntMap>(PrimitiveLongIntMap.class){

        @Override
        public Value<PrimitiveLongIntMap> randomValue() {
            final long x = PrimitiveCollectionEqualityTest.randomLong();
            final int y = PrimitiveCollectionEqualityTest.randomInt();
            return new Value<PrimitiveLongIntMap>(){

                @Override
                public void add(PrimitiveLongIntMap coll) {
                    coll.put(x, y);
                }

                @Override
                public boolean remove(PrimitiveLongIntMap coll) {
                    return coll.remove(x) == y;
                }
            };
        }
    };
    @DataPoint
    public static ValueProducer<PrimitiveLongLongMap> longLongV = new ValueProducer<PrimitiveLongLongMap>(PrimitiveLongLongMap.class){

        @Override
        public Value<PrimitiveLongLongMap> randomValue() {
            final long x = PrimitiveCollectionEqualityTest.randomLong();
            final long y = PrimitiveCollectionEqualityTest.randomLong();
            return new Value<PrimitiveLongLongMap>(){

                @Override
                public void add(PrimitiveLongLongMap coll) {
                    coll.put(x, y);
                }

                @Override
                public boolean remove(PrimitiveLongLongMap coll) {
                    return coll.remove(x) == y;
                }
            };
        }
    };
    @DataPoint
    public static ValueProducer<PrimitiveIntObjectMap> intObjV = new ValueProducer<PrimitiveIntObjectMap>(PrimitiveIntObjectMap.class){

        @Override
        public Value<PrimitiveIntObjectMap> randomValue() {
            final int x = PrimitiveCollectionEqualityTest.randomInt();
            final Object y = new Object();
            return new Value<PrimitiveIntObjectMap>(){

                @Override
                public void add(PrimitiveIntObjectMap coll) {
                    coll.put(x, y);
                }

                @Override
                public boolean remove(PrimitiveIntObjectMap coll) {
                    return coll.remove(x) == y;
                }
            };
        }
    };
    @DataPoint
    public static ValueProducer<PrimitiveLongObjectMap> longObjV = new ValueProducer<PrimitiveLongObjectMap>(PrimitiveLongObjectMap.class){

        @Override
        public Value<PrimitiveLongObjectMap> randomValue() {
            final long x = PrimitiveCollectionEqualityTest.randomLong();
            final Object y = new Object();
            return new Value<PrimitiveLongObjectMap>(){

                @Override
                public void add(PrimitiveLongObjectMap coll) {
                    coll.put(x, y);
                }

                @Override
                public boolean remove(PrimitiveLongObjectMap coll) {
                    return coll.remove(x) == y;
                }
            };
        }
    };
    @DataPoint
    public static Factory<PrimitiveIntSet> intSet = Primitive::intSet;
    @DataPoint
    public static Factory<PrimitiveIntSet> intSetWithCapacity = () -> Primitive.intSet((int)PrimitiveCollectionEqualityTest.randomCapacity());
    @DataPoint
    public static Factory<PrimitiveIntSet> offheapIntSet = Primitive::offHeapIntSet;
    @DataPoint
    public static Factory<PrimitiveIntSet> offheapIntSetWithCapacity = () -> Primitive.offHeapIntSet((int)PrimitiveCollectionEqualityTest.randomCapacity());
    @DataPoint
    public static Factory<PrimitiveLongSet> longSet = Primitive::longSet;
    @DataPoint
    public static Factory<PrimitiveLongSet> longSetWithCapacity = () -> Primitive.longSet((int)PrimitiveCollectionEqualityTest.randomCapacity());
    @DataPoint
    public static Factory<PrimitiveLongSet> offheapLongSet = Primitive::offHeapLongSet;
    @DataPoint
    public static Factory<PrimitiveLongSet> offheapLongSetWithCapacity = () -> Primitive.offHeapLongSet((int)PrimitiveCollectionEqualityTest.randomCapacity());
    @DataPoint
    public static Factory<PrimitiveIntLongMap> intLongMap = Primitive::intLongMap;
    @DataPoint
    public static Factory<PrimitiveIntLongMap> intLongMapWithCapacity = () -> Primitive.intLongMap((int)PrimitiveCollectionEqualityTest.randomCapacity());
    @DataPoint
    public static Factory<PrimitiveLongIntMap> longIntMap = Primitive::longIntMap;
    @DataPoint
    public static Factory<PrimitiveLongIntMap> longIntMapWithCapacity = () -> Primitive.longIntMap((int)PrimitiveCollectionEqualityTest.randomCapacity());
    @DataPoint
    public static Factory<PrimitiveLongLongMap> offheapLongLongMap = Primitive::offHeapLongLongMap;
    @DataPoint
    public static Factory<PrimitiveLongLongMap> offheapLongLongMapWithCapacity = () -> Primitive.offHeapLongLongMap((int)PrimitiveCollectionEqualityTest.randomCapacity());
    @DataPoint
    public static Factory<PrimitiveIntObjectMap> intObjMap = Primitive::intObjectMap;
    @DataPoint
    public static Factory<PrimitiveIntObjectMap> intObjMapWithCapacity = () -> Primitive.intObjectMap((int)PrimitiveCollectionEqualityTest.randomCapacity());
    @DataPoint
    public static Factory<PrimitiveLongObjectMap> longObjectMap = Primitive::longObjectMap;
    @DataPoint
    public static Factory<PrimitiveLongObjectMap> longObjectMapWithCapacity = () -> Primitive.longObjectMap((int)PrimitiveCollectionEqualityTest.randomCapacity());
    private static final PrimitiveIntSet observedRandomInts = Primitive.intSet();
    private static final PrimitiveLongSet observedRandomLongs = Primitive.longSet();

    private static int randomInt() {
        int n;
        while ((n = ThreadLocalRandom.current().nextInt()) == -1 || !observedRandomInts.add(n)) {
        }
        return n;
    }

    private static long randomLong() {
        long n;
        while ((n = ThreadLocalRandom.current().nextLong()) == -1L || !observedRandomLongs.add(n)) {
        }
        return n;
    }

    private static int randomCapacity() {
        return ThreadLocalRandom.current().nextInt(30, 1200);
    }

    private void assertEquals(PrimitiveCollection a, PrimitiveCollection b) {
        Assert.assertThat((Object)a, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)b)));
        Assert.assertThat((Object)b, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)a)));
        Assert.assertThat((Object)a.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)b.hashCode())));
    }

    @Theory
    public void collectionsAreNotEqualToObjectsOfOtherTypes(Factory<PrimitiveCollection> factory) {
        try (PrimitiveCollection coll = (PrimitiveCollection)factory.newInstance();){
            Assert.assertNotEquals((Object)coll, (Object)new Object());
        }
    }

    @Theory
    public void emptyCollectionsAreEqual(ValueProducer values, Factory<PrimitiveCollection> factoryA, Factory<PrimitiveCollection> factoryB) {
        Assume.assumeTrue((boolean)values.isApplicable(factoryA));
        Assume.assumeTrue((boolean)values.isApplicable(factoryB));
        try (PrimitiveCollection a = (PrimitiveCollection)factoryA.newInstance();
             PrimitiveCollection b = (PrimitiveCollection)factoryB.newInstance();){
            this.assertEquals(a, b);
        }
    }

    @Theory
    public void addingTheSameValuesMustProduceEqualCollections(ValueProducer values, Factory<PrimitiveCollection> factoryA, Factory<PrimitiveCollection> factoryB) {
        Assume.assumeTrue((boolean)values.isApplicable(factoryA));
        Assume.assumeTrue((boolean)values.isApplicable(factoryB));
        try (PrimitiveCollection a = (PrimitiveCollection)factoryA.newInstance();
             PrimitiveCollection b = (PrimitiveCollection)factoryB.newInstance();){
            Value<PrimitiveCollection> value = values.randomValue();
            value.add(a);
            value.add(b);
            this.assertEquals(a, b);
        }
    }

    @Theory
    public void addingDifferentValuesMustProduceUnequalCollections(ValueProducer values, Factory<PrimitiveCollection> factoryA, Factory<PrimitiveCollection> factoryB) {
        Assume.assumeTrue((boolean)values.isApplicable(factoryA));
        Assume.assumeTrue((boolean)values.isApplicable(factoryB));
        try (PrimitiveCollection a = (PrimitiveCollection)factoryA.newInstance();
             PrimitiveCollection b = (PrimitiveCollection)factoryB.newInstance();){
            values.randomValue().add(a);
            values.randomValue().add(b);
            Assert.assertNotEquals((Object)a, (Object)b);
        }
    }

    @Theory
    public void differentButEquivalentMutationsShouldProduceEqualCollections(ValueProducer values, Factory<PrimitiveCollection> factoryA, Factory<PrimitiveCollection> factoryB) {
        Assume.assumeTrue((boolean)values.isApplicable(factoryA));
        Assume.assumeTrue((boolean)values.isApplicable(factoryB));
        try (PrimitiveCollection a = (PrimitiveCollection)factoryA.newInstance();
             PrimitiveCollection b = (PrimitiveCollection)factoryB.newInstance();){
            Value<PrimitiveCollection> x = values.randomValue();
            Value<PrimitiveCollection> y = values.randomValue();
            Value<PrimitiveCollection> z = values.randomValue();
            x.add(a);
            z.add(a);
            z.add(b);
            y.add(b);
            x.add(b);
            y.remove(b);
            this.assertEquals(a, b);
        }
    }

    @Theory
    public void capacityDifferencesMustNotInfluenceEquality(ValueProducer values, Factory<PrimitiveCollection> factoryA, Factory<PrimitiveCollection> factoryB) {
        Assume.assumeTrue((boolean)values.isApplicable(factoryA));
        Assume.assumeTrue((boolean)values.isApplicable(factoryB));
        try (PrimitiveCollection a = (PrimitiveCollection)factoryA.newInstance();
             PrimitiveCollection b = (PrimitiveCollection)factoryB.newInstance();){
            ArrayList<Value> tmps = new ArrayList<Value>();
            for (int i = 0; i < 5000; ++i) {
                Value<PrimitiveCollection> value = values.randomValue();
                value.add(b);
                tmps.add(value);
            }
            Value<PrimitiveCollection> specificValue = values.randomValue();
            specificValue.add(a);
            specificValue.add(b);
            for (int i = 0; i < 5000; ++i) {
                Value value = values.randomValue();
                value.add(b);
                tmps.add(value);
            }
            Collections.shuffle(tmps);
            for (Value value : tmps) {
                value.remove(b);
            }
            this.assertEquals(a, b);
        }
    }

    @Theory
    public void hashCodeMustFollowValues(ValueProducer values, Factory<PrimitiveCollection> factory) {
        Assume.assumeTrue((boolean)values.isApplicable(factory));
        try (PrimitiveCollection a = (PrimitiveCollection)factory.newInstance();){
            Value<PrimitiveCollection> x = values.randomValue();
            Value<PrimitiveCollection> y = values.randomValue();
            Value<PrimitiveCollection> z = values.randomValue();
            int i = a.hashCode();
            x.add(a);
            int j = a.hashCode();
            y.add(a);
            int k = a.hashCode();
            z.add(a);
            int l = a.hashCode();
            z.remove(a);
            int m = a.hashCode();
            y.remove(a);
            int n = a.hashCode();
            x.remove(a);
            int o = a.hashCode();
            Assert.assertThat((String)"0 elm hashcode equal", (Object)o, (Matcher)Matchers.is((Object)i));
            Assert.assertThat((String)"1 elm hashcode equal", (Object)n, (Matcher)Matchers.is((Object)j));
            Assert.assertThat((String)"2 elm hashcode equal", (Object)m, (Matcher)Matchers.is((Object)k));
            Assert.assertThat((String)"3 elm hashcode distinct", (Object)l, (Matcher)Matchers.not((Matcher)Matchers.isOneOf((Object[])new Integer[]{i, j, k, m, n, o})));
            Assert.assertThat((String)"2 elm hashcode distinct", (Object)k, (Matcher)Matchers.not((Matcher)Matchers.isOneOf((Object[])new Integer[]{i, j, l, n, o})));
            Assert.assertThat((String)"1 elm hashcode distinct", (Object)n, (Matcher)Matchers.not((Matcher)Matchers.isOneOf((Object[])new Integer[]{i, k, l, m, o})));
            Assert.assertThat((String)"0 elm hashcode distinct", (Object)i, (Matcher)Matchers.not((Matcher)Matchers.isOneOf((Object[])new Integer[]{j, k, l, m, n})));
        }
    }

    private static abstract class ValueProducer<T extends PrimitiveCollection> {
        private final Class<T> applicableType;

        public ValueProducer(Class<T> applicableType) {
            this.applicableType = applicableType;
        }

        public boolean isApplicable(Factory<? extends PrimitiveCollection> factory) {
            try (PrimitiveCollection coll = (PrimitiveCollection)factory.newInstance();){
                boolean bl = this.applicableType.isInstance(coll);
                return bl;
            }
        }

        public abstract Value<T> randomValue();
    }

    private static interface Value<T extends PrimitiveCollection> {
        public void add(T var1);

        public boolean remove(T var1);
    }
}

