/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.concurrent;

import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.concurrent.Futures;

public class FuturesTest {
    private static final Runnable NOOP = new Runnable(){

        @Override
        public void run() {
        }
    };

    @Test
    public void combinedFutureShouldGetResultsAfterAllComplete() throws Exception {
        FutureTask<String> task1 = new FutureTask<String>(NOOP, "1");
        FutureTask<String> task2 = new FutureTask<String>(NOOP, "2");
        FutureTask<String> task3 = new FutureTask<String>(NOOP, "3");
        Future combined = Futures.combine((Future[])new Future[]{task1, task2, task3});
        try {
            combined.get(10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"should have timedout");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        task3.run();
        task2.run();
        try {
            combined.get(10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"should have timedout");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        task1.run();
        List result = (List)combined.get();
        Assert.assertThat((Object)result, (Matcher)Matchers.contains((Object[])new String[]{"1", "2", "3"}));
    }
}

