/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.concurrent;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.concurrent.Work;
import org.neo4j.concurrent.WorkSync;

public class WorkSyncTest {
    private UnsynchronisedAdder sum = new UnsynchronisedAdder();
    private UnsynchronisedAdder count = new UnsynchronisedAdder();
    private Adder adder = new Adder();
    private WorkSync<Adder, AddWork> sync = new WorkSync((Object)this.adder);

    private static void usleep(long micros) {
        long now;
        long deadline = System.nanoTime() + TimeUnit.MICROSECONDS.toNanos(micros);
        while ((now = System.nanoTime()) < deadline) {
        }
    }

    @Test
    public void mustApplyWork() throws Exception {
        this.sync.apply((Work)new AddWork(10));
        Assert.assertThat((Object)this.sum.sum(), (Matcher)Matchers.is((Object)10L));
        this.sync.apply((Work)new AddWork(20));
        Assert.assertThat((Object)this.sum.sum(), (Matcher)Matchers.is((Object)30L));
    }

    @Test
    public void mustCombineWork() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(64);
        for (int i = 0; i < 1000; ++i) {
            executor.submit(new CallableWork(new AddWork(1)));
        }
        executor.shutdown();
        Assert.assertTrue((boolean)executor.awaitTermination(2L, TimeUnit.SECONDS));
        Assert.assertThat((Object)this.count.sum(), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(this.sum.sum())));
    }

    @Test
    public void mustApplyWorkEvenWhenInterrupted() throws Exception {
        Thread.currentThread().interrupt();
        this.sync.apply((Work)new AddWork(10));
        Assert.assertThat((Object)this.sum.sum(), (Matcher)Matchers.is((Object)10L));
        Assert.assertTrue((boolean)Thread.interrupted());
    }

    @Test(timeout=1000L)
    public void mustRecoverFromExceptions() throws Exception {
        final AtomicBoolean broken = new AtomicBoolean(true);
        Adder adder = new Adder(){

            @Override
            public void add(int delta) {
                if (broken.get()) {
                    throw new IllegalStateException("boom!");
                }
                super.add(delta);
            }
        };
        this.sync = new WorkSync((Object)adder);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            executor.submit(new CallableWork(new AddWork(10))).get();
            Assert.fail((String)"Should have thrown");
        }
        catch (ExecutionException exception) {
            Assert.assertThat((Object)exception.getCause(), (Matcher)Matchers.instanceOf(ExecutionException.class));
            exception = (ExecutionException)exception.getCause();
            Assert.assertThat((Object)exception.getCause(), (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
        broken.set(false);
        this.sync.apply((Work)new AddWork(20));
        Assert.assertThat((Object)this.sum.sum(), (Matcher)Matchers.is((Object)20L));
        Assert.assertThat((Object)this.count.sum(), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void mustNotApplyWorkInParallelUnderStress() throws Exception {
        int workers = Runtime.getRuntime().availableProcessors() * 5;
        int iterations = 1000;
        int incrementValue = 42;
        CountDownLatch startLatch = new CountDownLatch(workers);
        CountDownLatch endLatch = new CountDownLatch(workers);
        ExecutorService executor = Executors.newFixedThreadPool(workers);
        AtomicBoolean start = new AtomicBoolean();
        Callable<Void> work = () -> {
            boolean spin;
            startLatch.countDown();
            while (spin = !start.get()) {
            }
            for (int i = 0; i < iterations; ++i) {
                this.sync.apply((Work)new AddWork(incrementValue));
            }
            endLatch.countDown();
            return null;
        };
        ArrayList<Future<Void>> futureList = new ArrayList<Future<Void>>();
        for (int i = 0; i < workers; ++i) {
            futureList.add(executor.submit(work));
        }
        startLatch.await();
        start.set(true);
        endLatch.await();
        for (Future future : futureList) {
            future.get();
        }
        Assert.assertThat((Object)this.count.sum(), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(workers * iterations)));
        Assert.assertThat((Object)this.sum.sum(), (Matcher)Matchers.is((Object)(incrementValue * workers * iterations)));
    }

    private static class UnsynchronisedAdder {
        private volatile long value;

        private UnsynchronisedAdder() {
        }

        public void add(long delta) {
            long v = this.value;
            Thread.yield();
            WorkSyncTest.usleep(ThreadLocalRandom.current().nextInt(50));
            this.value = v + delta;
        }

        public void increment() {
            this.add(1L);
        }

        public long sum() {
            return this.value;
        }
    }

    private class CallableWork
    implements Callable<Void> {
        private final AddWork addWork;

        CallableWork(AddWork addWork) {
            this.addWork = addWork;
        }

        @Override
        public Void call() throws ExecutionException {
            WorkSyncTest.this.sync.apply((Work)this.addWork);
            return null;
        }
    }

    private class Adder {
        private Adder() {
        }

        public void add(int delta) {
            WorkSyncTest.this.sum.add(delta);
            WorkSyncTest.this.count.increment();
        }
    }

    private static class AddWork
    implements Work<Adder, AddWork> {
        private int delta;

        private AddWork(int delta) {
            this.delta = delta;
        }

        public AddWork combine(AddWork work) {
            this.delta += work.delta;
            return this;
        }

        public void apply(Adder adder) {
            WorkSyncTest.usleep(50L);
            adder.add(this.delta);
        }
    }
}

