/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.routing;

import java.util.Optional;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.procedure.builtin.routing.BaseRoutingTableProcedureValidator;
import org.neo4j.procedure.builtin.routing.RoutingTableProcedureHelpers;

public class LocalRoutingTableProcedureValidator
extends BaseRoutingTableProcedureValidator {
    public LocalRoutingTableProcedureValidator(DatabaseManager<?> databaseManager) {
        super(databaseManager);
    }

    @Override
    public void isValidForServerSideRouting(NamedDatabaseId namedDatabaseId) throws ProcedureException {
        this.assertDatabaseIsOperational(namedDatabaseId);
    }

    @Override
    public void isValidForClientSideRouting(NamedDatabaseId namedDatabaseId) throws ProcedureException {
        this.assertDatabaseIsOperational(namedDatabaseId);
    }

    private void assertDatabaseIsOperational(NamedDatabaseId namedDatabaseId) throws ProcedureException {
        Optional<Database> database = this.getDatabase(namedDatabaseId);
        if (database.isEmpty()) {
            throw RoutingTableProcedureHelpers.databaseNotFoundException(namedDatabaseId.name());
        }
        if (!database.get().getDatabaseAvailabilityGuard().isAvailable()) {
            throw new ProcedureException((Status)Status.Database.DatabaseUnavailable, "Unable to get a routing table for database '" + namedDatabaseId.name() + "' because this database is unavailable", new Object[0]);
        }
    }

    Optional<Database> getDatabase(NamedDatabaseId databaseId) {
        return this.databaseManager.getDatabaseContext(databaseId).map(DatabaseContext::database);
    }
}

